/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.util.ext;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.util.MiscellaneousUtil;
import org.apache.synapse.commons.util.ext.TenantInfoInitiator;

public final class TenantInfoInitiatorProvider {
    private static final Log logger = LogFactory.getLog((String)TenantInfoInitiator.class.getName());
    public static final String CARBON_TENANT_INFO_INITIATOR = "synapse.carbon.ext.tenant.info.initiator";
    public static final String PROPERTY_FILE_PATH = "synapse.properties";
    private static TenantInfoInitiator tenantInfoInitiatorInstance = null;

    private TenantInfoInitiatorProvider() {
    }

    public static TenantInfoInitiator getTenantInfoInitiator() {
        if (tenantInfoInitiatorInstance == null) {
            try {
                Properties properties = MiscellaneousUtil.loadProperties(PROPERTY_FILE_PATH);
                String property = properties.getProperty(CARBON_TENANT_INFO_INITIATOR);
                if (property != null) {
                    Class<?> clazz = TenantInfoInitiator.class.getClassLoader().loadClass(property.trim());
                    tenantInfoInitiatorInstance = (TenantInfoInitiator)clazz.newInstance();
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error while initializing tenant info configuration provider. Error:" + e.getLocalizedMessage()));
            }
        }
        return tenantInfoInitiatorInstance;
    }
}

