/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;

public class FilePropertyLoader {
    private static final Log LOG = LogFactory.getLog(FilePropertyLoader.class);
    private static final String CONF_LOCATION = "conf.location";
    public static final String FILE_PROPERTY_PATH = "properties.file.path";
    private static final String DEFAULT_PROPERTY_FILE = "file.properties";
    private static Map propertyMap;
    private static FilePropertyLoader fileLoaderInstance;

    public static FilePropertyLoader getInstance() {
        if (null == fileLoaderInstance) {
            fileLoaderInstance = new FilePropertyLoader();
            fileLoaderInstance.loadPropertiesFile();
        }
        return fileLoaderInstance;
    }

    public String getValue(String input) {
        return (String)propertyMap.get(input);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadPropertiesFile() throws SynapseCommonsException {
        File file;
        boolean isFileExists;
        String filePath = System.getProperty(FILE_PROPERTY_PATH);
        if (null == filePath || filePath.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"properties.file.path is empty or null");
            }
            propertyMap = new HashMap();
            return;
        }
        if ("default".equals(filePath)) {
            filePath = System.getProperty(CONF_LOCATION) + File.separator + DEFAULT_PROPERTY_FILE;
        }
        if (!(isFileExists = (file = new File(filePath)).exists())) throw new SynapseCommonsException("File cannot found in " + filePath);
        try (FileInputStream in = new FileInputStream(filePath);){
            Properties rawProps = new Properties();
            propertyMap = new HashMap();
            rawProps.load(in);
            for (Map.Entry<Object, Object> propertyEntry : rawProps.entrySet()) {
                String strValue = (String)propertyEntry.getValue();
                propertyMap.put(propertyEntry.getKey(), strValue);
            }
            if (!LOG.isDebugEnabled()) return;
            LOG.debug((Object)("Loaded factory properties from " + filePath + ": " + propertyMap));
            return;
        }
        catch (IOException ex) {
            throw new SynapseCommonsException("Failed to read " + filePath, ex);
        }
    }

    public static Map getPropertyMap() {
        if (propertyMap == null) {
            FilePropertyLoader.getInstance();
        }
        return propertyMap;
    }
}

