/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TranscationManger {
    protected static final Log log = LogFactory.getLog(TranscationManger.class);
    private static ConcurrentHashMap<Long, ConnectionMapper> connections = new ConcurrentHashMap();
    private static final String TRANSCATION_MANGER_LOOKUP_STR = "java:comp/TransactionManager";
    private static ThreadLocal<Map<Long, XAResource>> enlistedXADataSources = new ThreadLocal<Map<Long, XAResource>>(){

        @Override
        protected Map<Long, XAResource> initialValue() {
            return new HashMap<Long, XAResource>();
        }
    };
    private static ThreadLocal<Map<Long, TransactionManager>> txManagers = new ThreadLocal<Map<Long, TransactionManager>>(){

        @Override
        protected Map<Long, TransactionManager> initialValue() {
            return new HashMap<Long, TransactionManager>();
        }
    };
    private static ThreadLocal<Map<Long, Transaction>> transactions = new ThreadLocal<Map<Long, Transaction>>(){

        @Override
        protected Map<Long, Transaction> initialValue() {
            return new HashMap<Long, Transaction>();
        }
    };

    public static void lookUp(Context txContext) throws Exception {
        long key = Thread.currentThread().getId();
        Map<Long, TransactionManager> txMgrMap = txManagers.get();
        if (!txMgrMap.containsKey(key)) {
            TransactionManager transactionManager = (TransactionManager)txContext.lookup(TRANSCATION_MANGER_LOOKUP_STR);
            txMgrMap.put(key, transactionManager);
            if (log.isDebugEnabled()) {
                StringBuilder logMsg = new StringBuilder();
                logMsg.append(" Transaction Mgr Hashcode : " + transactionManager.hashCode()).append("\n").append(" Transaction Mgr  : " + transactionManager);
                log.debug((Object)logMsg.toString());
            }
        }
    }

    private static boolean isXAResourceEnlisted(XAResource resource) throws Exception {
        long key = Thread.currentThread().getId();
        return enlistedXADataSources.get().containsKey(key) && enlistedXADataSources.get().containsValue(resource);
    }

    public static boolean checkConnectionAlreadyUse(Connection conn) throws SQLException {
        boolean isUsed = false;
        if (connections.containsValue(new ConnectionMapper(conn))) {
            isUsed = true;
            log.debug((Object)(" Connection toString : " + conn.toString()));
        }
        return isUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnectionUsed(long key) {
        boolean contains = false;
        try {
            if (connections.containsKey(key)) {
                contains = true;
                Connection conn = TranscationManger.connections.get(key).getConnection();
                if (conn != null) {
                    log.debug((Object)(" Connection close for Thread Id : " + key));
                    conn.close();
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)(" Ignore this error " + ex));
        }
        finally {
            if (contains) {
                connections.remove(key);
            }
        }
    }

    public static Connection addConnection(DataSource ds) throws Exception {
        long key = Thread.currentThread().getId();
        Connection conn = TranscationManger.getConnection();
        if (conn != null) {
            log.debug((Object)(" Connection can get from map : " + key));
            return conn;
        }
        int count = 0;
        do {
            conn = ds.getConnection();
            Connection actual = ((PooledConnection)((Object)conn)).getConnection();
            if (conn == null || actual == null) continue;
            if (!TranscationManger.checkConnectionAlreadyUse(conn) && !actual.isClosed()) {
                if (connections.containsKey(key)) break;
                connections.putIfAbsent(key, new ConnectionMapper(conn));
                log.debug((Object)(" Connection added to map in attempt : " + count + " Thread : " + key));
                break;
            }
            conn.close();
            conn = null;
            Thread.sleep(500L);
        } while (++count < 5);
        if (conn == null && count >= 5) {
            throw new Exception(" Not enough Connections in the pool, Cache size : " + connections.size());
        }
        return conn;
    }

    public static Connection getConnection() {
        long key = Thread.currentThread().getId();
        ConnectionMapper connMapper = connections.get(key);
        Connection conn = connMapper != null ? connMapper.getConnection() : null;
        return conn;
    }

    public static boolean isThreadHasEnlistment() {
        long key = Thread.currentThread().getId();
        boolean hasEnlistment = enlistedXADataSources.get().containsKey(key) ? enlistedXADataSources.get().get(key) != null : false;
        return hasEnlistment;
    }

    public static void bindConnection(Connection conn) throws Exception {
        long key = Thread.currentThread().getId();
        try {
            if (conn instanceof XAConnection) {
                Transaction tx = transactions.get().get(key);
                XAResource xaRes = ((XAConnection)((Object)conn)).getXAResource();
                if (!TranscationManger.isXAResourceEnlisted(xaRes)) {
                    tx.enlistResource(xaRes);
                    TranscationManger.addToEnlistedXADataSources(xaRes, key);
                    log.debug((Object)(" DS enlisted in thread " + key + " XA Resource : " + xaRes.hashCode()));
                }
            }
        }
        catch (Exception ex) {
            StringBuilder logMsg = new StringBuilder();
            Connection actual = ((PooledConnection)((Object)conn)).getConnection();
            logMsg.append(" Thread Id : " + key).append(" BIND ERROR , Transaction Manager status : " + txManagers.get().get(key).getStatus()).append("\n").append(" BIND ERROR , Transaction status : " + transactions.get().get(key).getStatus()).append("\n").append(" JDBC Connection status : " + actual.isClosed()).append("\n").append(" BIND ERROR  : " + ex);
            log.error((Object)logMsg.toString());
            TranscationManger.rollbackTransaction(true, key);
            throw ex;
        }
    }

    public static void delistResource(int flag, long key) throws Exception {
        Map<Long, XAResource> enlistedResources = enlistedXADataSources.get();
        XAResource resource = null;
        try {
            if (enlistedResources != null && !enlistedResources.isEmpty()) {
                Transaction tx = transactions.get().get(key);
                resource = enlistedResources.get(key);
                if (tx != null && resource != null) {
                    tx.delistResource(resource, flag);
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Error occurred while delisting datasource connection: " + ex.getMessage(), ex);
        }
        finally {
            TranscationManger.removeConnectionUsed(key);
            TranscationManger.removeTransaction(key);
            enlistedResources.remove(key);
        }
    }

    public static void removeTransaction(long key) {
        transactions.get().remove(key);
    }

    private static void addToEnlistedXADataSources(XAResource resource, long key) throws Exception {
        if (resource != null) {
            enlistedXADataSources.get().put(key, resource);
        }
    }

    public static void rollbackTransaction(boolean insideSynapse, long key) throws Exception {
        int xaResourceStatus = 0x20000000;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"rollbackTransaction()");
            }
            if (insideSynapse && transactions.get() == null) {
                log.warn((Object)" ROLLBACK Thread Local null ");
                return;
            }
            if (insideSynapse && transactions.get().get(key) == null) {
                log.warn((Object)" ROLLBACK Some How TX null ");
                return;
            }
            if (transactions.get().get(key) != null && 0 == transactions.get().get(key).getStatus()) {
                txManagers.get().get(key).rollback();
                xaResourceStatus = 0x20000000;
            }
        }
        catch (Exception ex) {
            log.error((Object)(" ROLLBACK ERROR  : " + txManagers.get().get(key).getStatus()));
            throw ex;
        }
        finally {
            TranscationManger.delistResource(xaResourceStatus, key);
        }
    }

    public static void endTransaction(boolean insideSynapse, long key) throws Exception {
        int xaResourceStatus = 0;
        try {
            if (insideSynapse && transactions.get() == null) {
                log.warn((Object)" END Thread Local null ");
                return;
            }
            if (insideSynapse && transactions.get().get(key) == null) {
                log.warn((Object)" END Some How TX null ");
                return;
            }
            if (transactions.get().get(key) != null && 0 == transactions.get().get(key).getStatus()) {
                txManagers.get().get(key).commit();
                xaResourceStatus = 0x4000000;
            }
        }
        catch (Exception ex) {
            xaResourceStatus = 0x20000000;
            log.error((Object)(" END ERROR : " + txManagers.get().get(key).getStatus()));
            throw ex;
        }
        finally {
            TranscationManger.delistResource(xaResourceStatus, key);
        }
    }

    public static void beginTransaction() throws Exception {
        long key = Thread.currentThread().getId();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"beginTransaction()");
            }
            TransactionManager txMgr = txManagers.get().get(key);
            txMgr.begin();
            Transaction tx = txMgr.getTransaction();
            transactions.get().put(key, tx);
            log.debug((Object)(" BEGIN  : " + transactions.get().get(key).getStatus()));
        }
        catch (Exception ex) {
            log.debug((Object)(" BEGIN ERROR  : " + txManagers.get().get(key).getStatus()));
            throw ex;
        }
    }

    public static TransactionManager getTransactionManager() throws Exception {
        long key = Thread.currentThread().getId();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getTransactionManager Called");
            }
            TransactionManager txMgr = txManagers.get().get(key);
            return txMgr;
        }
        catch (Exception ex) {
            log.error((Object)(" BEGIN ERROR  : " + txManagers.get().get(key).getStatus()));
            throw ex;
        }
    }

    public static Transaction getTransaction() throws Exception {
        long key = Thread.currentThread().getId();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getTransaction Called");
            }
            return transactions.get().get(key);
        }
        catch (Exception ex) {
            log.error((Object)(" BEGIN ERROR  : " + txManagers.get().get(key).getStatus()));
            throw ex;
        }
    }

    public static int getStatus() throws Exception {
        long key = Thread.currentThread().getId();
        int status = 5;
        if (transactions.get().get(key) == null) {
            if (enlistedXADataSources.get().containsKey(key) && enlistedXADataSources.get().get(key) != null) {
                log.warn((Object)" END Some How TX null ");
            } else {
                status = 6;
            }
        } else {
            status = transactions.get().get(key).getStatus();
        }
        return status;
    }

    private static class ConnectionMapper {
        private final Connection realConn;
        private final String key;

        private ConnectionMapper(Connection conn) {
            this.realConn = conn;
            this.key = conn.toString();
        }

        private Connection getConnection() {
            return this.realConn;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionMapper other = (ConnectionMapper)obj;
            return !(this.key == null ? other.key != null : !this.key.equals(other.key));
        }
    }
}

