/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core.internal;

import com.hazelcast.core.HazelcastInstance;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.ThrottleUtil;
import org.apache.synapse.commons.throttle.core.internal.ThrottleServiceDataHolder;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(name="throttle.core.services", immediate=true)
public class ThrottleServiceComponent {
    private static final Log log = LogFactory.getLog((String)ThrottleServiceComponent.class.getName());

    @Activate
    protected void activate(ComponentContext context) {
        log.debug((Object)"Activating throttle core service component");
        if (ThrottleServiceDataHolder.getInstance().getThrottleProperties() == null) {
            ThrottleServiceDataHolder.getInstance().setThrottleProperties(ThrottleUtil.loadThrottlePropertiesFromConfigurations());
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        log.debug((Object)"Deactivating throttle core service component");
    }

    @Reference(name="hazelcast.instance.service", service=HazelcastInstance.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetHazelcastInstance")
    protected void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        ThrottleServiceDataHolder.getInstance().setHazelCastInstance(hazelcastInstance);
    }

    protected void unsetHazelcastInstance(HazelcastInstance hazelcastInstance) {
        ThrottleServiceDataHolder.getInstance().setHazelCastInstance(null);
    }
}

