/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core.factory;

import org.apache.synapse.commons.throttle.core.ThrottleConfiguration;
import org.apache.synapse.commons.throttle.core.ThrottleContext;
import org.apache.synapse.commons.throttle.core.ThrottleContextCleanupTask;
import org.apache.synapse.commons.throttle.core.ThrottleDistributedInstancesCleanupTask;
import org.apache.synapse.commons.throttle.core.ThrottleException;
import org.apache.synapse.commons.throttle.core.ThrottleReplicator;
import org.apache.synapse.commons.throttle.core.ThrottleWindowReplicator;
import org.apache.synapse.commons.throttle.core.impl.domainbase.DomainBaseThrottleContext;
import org.apache.synapse.commons.throttle.core.impl.ipbase.IPBaseThrottleContext;
import org.apache.synapse.commons.throttle.core.impl.rolebase.RoleBaseThrottleContext;

public class ThrottleContextFactory {
    private static final ThrottleReplicator throttleReplicator = new ThrottleReplicator();
    private static final ThrottleWindowReplicator throttleWindowReplicator = new ThrottleWindowReplicator();
    private static final ThrottleContextCleanupTask throttleContextCleanupTask = new ThrottleContextCleanupTask();
    private static final ThrottleDistributedInstancesCleanupTask distributedObjectsCleanupTask = new ThrottleDistributedInstancesCleanupTask();

    public static ThrottleContext createThrottleContext(int throttletype, ThrottleConfiguration configuration) throws ThrottleException {
        if (0 == throttletype) {
            return new IPBaseThrottleContext(configuration, throttleReplicator);
        }
        if (1 == throttletype) {
            return new DomainBaseThrottleContext(configuration, throttleReplicator);
        }
        if (2 == throttletype) {
            return new RoleBaseThrottleContext(configuration, throttleReplicator);
        }
        throw new ThrottleException("Unknown throttle type");
    }

    public static ThrottleWindowReplicator getThrottleWindowReplicatorInstance() {
        return throttleWindowReplicator;
    }

    public static ThrottleContextCleanupTask getThrottleContextCleanupTaskInstance() {
        return throttleContextCleanupTask;
    }
}

