/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.CallerContext;
import org.apache.synapse.commons.throttle.core.ThrottleProperties;

public class ThrottleUtil {
    private static Log log = LogFactory.getLog((String)ThrottleUtil.class.getName());
    public static final String THROTTLING_CACHE_MANAGER = "throttling.cache.manager";
    private static final String CONF_LOCATION = "conf.location";
    public static final String THROTTLING_CACHE = "throttling.cache";

    public static ThrottleProperties loadThrottlePropertiesFromConfigurations() {
        ThrottleProperties throttleProperties;
        block27: {
            throttleProperties = new ThrottleProperties();
            Properties properties = new Properties();
            String throttlePropertiesFileLocation = null;
            if (System.getProperty(CONF_LOCATION) != null) {
                throttlePropertiesFileLocation = System.getProperty(CONF_LOCATION) + File.separator + "throttle.properties";
                try {
                    properties.load(new FileInputStream(throttlePropertiesFileLocation));
                    String throttleFrequency = properties.getProperty("throttling.context.cleanup.frequency");
                    if (!StringUtils.isEmpty((String)throttleFrequency)) {
                        throttleProperties.setThrottleFrequency(throttleFrequency);
                    } else {
                        throttleProperties.setThrottleFrequency("3600000");
                    }
                    String throttleContextDistributedCleanupTaskFrequency = properties.getProperty("throttling.context.distributed.cleanup.frequency");
                    if (throttleContextDistributedCleanupTaskFrequency != null && throttleContextDistributedCleanupTaskFrequency != "") {
                        throttleProperties.setThrottleContextDistributedCleanupTaskFrequency(throttleContextDistributedCleanupTaskFrequency);
                    } else {
                        throttleProperties.setThrottleContextDistributedCleanupTaskFrequency("3600000");
                    }
                    String throttleContextDistributedExpiredInstanceTime = properties.getProperty("throttling.context.distributed.expired.instance.time");
                    if (throttleContextDistributedExpiredInstanceTime != null && throttleContextDistributedExpiredInstanceTime != "") {
                        throttleProperties.setThrottleContextDistributedExpiredInstanceTime(throttleContextDistributedExpiredInstanceTime);
                    } else {
                        throttleProperties.setThrottleContextDistributedExpiredInstanceTime("3600000");
                    }
                    String throttleDistributedCleanupPoolSize = properties.getProperty("throttling.context.distributed.cleanup.pool.size");
                    if (throttleDistributedCleanupPoolSize != null && throttleDistributedCleanupPoolSize != "") {
                        throttleProperties.setThrottleDistributedCleanupPoolSize(throttleDistributedCleanupPoolSize);
                    } else {
                        throttleProperties.setThrottleDistributedCleanupPoolSize("1");
                    }
                    String throttleDistributedCleanupAmount = properties.getProperty("throttling.context.distributed.cleanup.amount");
                    if (throttleDistributedCleanupAmount != null && throttleDistributedCleanupAmount != "") {
                        throttleProperties.setThrottleDistributedCleanupAmount(throttleDistributedCleanupAmount);
                    } else {
                        throttleProperties.setThrottleDistributedCleanupAmount("25000");
                    }
                    String throttleDistributedCleanupTaskEnable = properties.getProperty("throttling.context.distributed.cleanup.task.enabled");
                    if (throttleDistributedCleanupTaskEnable != null && throttleDistributedCleanupTaskEnable != "") {
                        throttleProperties.setThrottleDistributedCleanupTaskEnable(throttleDistributedCleanupTaskEnable);
                    } else {
                        throttleProperties.setThrottleDistributedCleanupTaskEnable("true");
                    }
                    String maxNonAssociatedCounterCleanupAmount = properties.getProperty("stale.counter.references");
                    if (maxNonAssociatedCounterCleanupAmount != null && maxNonAssociatedCounterCleanupAmount != "") {
                        throttleProperties.setMaxNonAssociatedCounterCleanupAmount(maxNonAssociatedCounterCleanupAmount);
                    } else {
                        throttleProperties.setMaxNonAssociatedCounterCleanupAmount("25000");
                    }
                    String throttlingPoolSize = properties.getProperty("throttling.pool.size");
                    if (throttlingPoolSize != null && throttlingPoolSize != "") {
                        throttleProperties.setThrottlingPoolSize(throttlingPoolSize);
                    } else {
                        throttleProperties.setThrottlingPoolSize("1");
                    }
                    String throttlingReplicationFrequency = properties.getProperty("throttling.replication.frequency");
                    if (throttlingReplicationFrequency != null && throttlingReplicationFrequency != "") {
                        throttleProperties.setThrottlingReplicationFrequency(throttlingReplicationFrequency);
                    } else {
                        throttleProperties.setThrottlingReplicationFrequency("50");
                    }
                    String throttlingKeysToReplicate = properties.getProperty("throttling.keys.to.replicate");
                    if (throttlingKeysToReplicate != null && throttlingKeysToReplicate != "") {
                        throttleProperties.setThrottlingKeysToReplicates(throttlingKeysToReplicate);
                    } else {
                        throttleProperties.setThrottlingKeysToReplicates("25000");
                    }
                    String windowReplicatorPoolSize = properties.getProperty("throttlingWindowReplicator.pool.size");
                    if (windowReplicatorPoolSize != null && windowReplicatorPoolSize != "") {
                        throttleProperties.setWindowReplicatorPoolSize(windowReplicatorPoolSize);
                    } else {
                        throttleProperties.setWindowReplicatorPoolSize("1");
                    }
                    String windowReplicatorFrequency = properties.getProperty("throttlingWindowReplicator.replication.frequency");
                    if (windowReplicatorFrequency != null && windowReplicatorFrequency != "") {
                        throttleProperties.setWindowReplicatorFrequency(windowReplicatorFrequency);
                        break block27;
                    }
                    throttleProperties.setWindowReplicatorFrequency("50");
                }
                catch (IOException e) {
                    log.debug((Object)"Setting the Default Throttle Properties");
                    throttleProperties.setThrottleFrequency("3600000");
                    throttleProperties.setThrottleContextDistributedCleanupTaskFrequency("3600000");
                    throttleProperties.setThrottleContextDistributedExpiredInstanceTime("3600000");
                    throttleProperties.setThrottleDistributedCleanupPoolSize("1");
                    throttleProperties.setThrottleDistributedCleanupAmount("25000");
                    throttleProperties.setThrottleDistributedCleanupTaskEnable("true");
                    throttleProperties.setMaxNonAssociatedCounterCleanupAmount("25000");
                    throttleProperties.setThrottlingPoolSize("1");
                    throttleProperties.setThrottlingReplicationFrequency("50");
                    throttleProperties.setThrottlingKeysToReplicates("25000");
                    throttleProperties.setWindowReplicatorPoolSize("1");
                    throttleProperties.setWindowReplicatorFrequency("50");
                }
            } else {
                log.debug((Object)"Setting the Default Throttle Properties");
                throttleProperties.setThrottleFrequency("3600000");
                throttleProperties.setThrottleContextDistributedCleanupTaskFrequency("3600000");
                throttleProperties.setThrottleContextDistributedExpiredInstanceTime("3600000");
                throttleProperties.setThrottleDistributedCleanupPoolSize("1");
                throttleProperties.setThrottleDistributedCleanupAmount("25000");
                throttleProperties.setThrottleDistributedCleanupTaskEnable("true");
                throttleProperties.setMaxNonAssociatedCounterCleanupAmount("25000");
                throttleProperties.setThrottlingPoolSize("1");
                throttleProperties.setThrottlingReplicationFrequency("50");
                throttleProperties.setThrottlingKeysToReplicates("25000");
                throttleProperties.setWindowReplicatorPoolSize("1");
                throttleProperties.setWindowReplicatorFrequency("50");
            }
        }
        return throttleProperties;
    }

    public static Cache<String, CallerContext> getThrottleCache() {
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(THROTTLING_CACHE_MANAGER);
        Cache cache = cacheManager != null ? cacheManager.getCache(THROTTLING_CACHE) : Caching.getCacheManager().getCache(THROTTLING_CACHE);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created throttling cache : " + cache));
        }
        return cache;
    }
}

