/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.SharedParamManager;
import org.apache.synapse.commons.throttle.core.ThrottleProperties;
import org.apache.synapse.commons.throttle.core.internal.ThrottleServiceDataHolder;

public class ThrottleDistributedInstancesCleanupTask {
    private static final Log log = LogFactory.getLog(ThrottleDistributedInstancesCleanupTask.class);
    private static final int CLEANUP_THREAD_POOL_SIZE = 1;
    private static int cleanUpPoolSize = 1;
    private boolean distributedCleanupEnabled = true;
    private int maxNonAssociatedCounterCountToClear = 50000;
    private long distributedInstanceExpiryMillis;
    private long noOfTimestampObjectToBeCleared;
    private ThrottleProperties throttleProperties = ThrottleServiceDataHolder.getInstance().getThrottleProperties();

    public ThrottleDistributedInstancesCleanupTask() {
        cleanUpPoolSize = Integer.parseInt(this.throttleProperties.getThrottleDistributedCleanupPoolSize());
        this.noOfTimestampObjectToBeCleared = Long.parseLong(this.throttleProperties.getThrottleDistributedCleanupAmount());
        this.distributedCleanupEnabled = Boolean.parseBoolean(this.throttleProperties.getThrottleDistributedCleanupTaskEnable());
        this.maxNonAssociatedCounterCountToClear = Integer.parseInt(this.throttleProperties.getMaxNonAssociatedCounterCleanupAmount());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Throttle window replicator pool size set to " + cleanUpPoolSize));
        }
        if (this.distributedCleanupEnabled) {
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(cleanUpPoolSize, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setName("Throttle Distributed Cleanup Task");
                    return t;
                }
            });
            String throttleFrequency = this.throttleProperties.getThrottleContextDistributedCleanupTaskFrequency();
            String distributedInstanceExpiry = this.throttleProperties.getThrottleContextDistributedExpiredInstanceTime();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Throttling Cleanup Task Frequency set to " + throttleFrequency));
            }
            executor.scheduleAtFixedRate(new CleanupTask(), Integer.parseInt(throttleFrequency), Integer.parseInt(throttleFrequency), TimeUnit.MILLISECONDS);
            this.distributedInstanceExpiryMillis = Long.parseLong(distributedInstanceExpiry);
        }
    }

    private static HazelcastInstance getHazelcastInstance() {
        return ThrottleServiceDataHolder.getInstance().getHazelCastInstance();
    }

    private class CleanupTask
    implements Runnable {
        private CleanupTask() {
        }

        @Override
        public void run() {
            HazelcastInstance hazelcastInstance;
            HashMap<String, String> timestamps = new HashMap<String, String>();
            HashMap<String, String> removedTimestamps = new HashMap<String, String>();
            ArrayList<String> counters = new ArrayList<String>();
            long removedCounterCount = 0L;
            long atomicLongCount = 0L;
            long removedAtomicTimestampCount = 0L;
            long start = 0L;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Running the distributed counter cleanup task");
                start = System.currentTimeMillis();
            }
            if ((hazelcastInstance = ThrottleDistributedInstancesCleanupTask.getHazelcastInstance()) != null && ((Member)hazelcastInstance.getCluster().getMembers().iterator().next()).localMember()) {
                Collection distributedObjects = hazelcastInstance.getDistributedObjects();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TOTAL NUMBER OF DISTRIBUTED OBJECTS BEFORE CLEAN-UP " + distributedObjects.size()));
                }
                long currentTime = System.currentTimeMillis();
                for (DistributedObject distributedObject : distributedObjects) {
                    String serviceName = distributedObject.getServiceName();
                    if (!"hz:impl:atomicLongService".equals(serviceName)) continue;
                    String name = distributedObject.getName();
                    if (name.contains("startedTime-")) {
                        String counterKey = name.split("startedTime-")[1];
                        long timestamp = SharedParamManager.getSharedTimestampWithFullId(name);
                        timestamps.put(counterKey, counterKey);
                        log.debug((Object)("ADDING TIMESTAMP:============" + counterKey));
                        log.debug((Object)("TIMESTAMP VALUE:============" + timestamp));
                        if (timestamp < currentTime - ThrottleDistributedInstancesCleanupTask.this.distributedInstanceExpiryMillis && removedAtomicTimestampCount < ThrottleDistributedInstancesCleanupTask.this.noOfTimestampObjectToBeCleared) {
                            log.debug((Object)("REMOVING TIMESTAMP:============" + counterKey));
                            SharedParamManager.removeTimestampWithFullId(name);
                            removedTimestamps.put(counterKey, counterKey);
                            ++removedAtomicTimestampCount;
                        }
                    } else if (name.contains("sharedCounter-")) {
                        log.debug((Object)("ADDING COUNTER:============" + name.split("sharedCounter-")[1]));
                        counters.add(name.split("sharedCounter-")[1]);
                    }
                    ++atomicLongCount;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TOTAL NUMBER OF DISTRIBUTED TIMESTAMP OBJECTS CLEARED " + removedTimestamps.size()));
                    log.debug((Object)("TOTAL NUMBER OF DISTRIBUTED TIMESTAMP OBJECTS " + timestamps.size()));
                    log.debug((Object)("TOTAL NUMBER OF DISTRIBUTED COUNTER OBJECTS " + counters.size()));
                }
                int nonTimestampAssociatedCountersCount = 0;
                for (String key : counters) {
                    if (timestamps.containsKey(key)) {
                        if (!removedTimestamps.containsKey(key)) continue;
                        log.debug((Object)("REMOVING COUNTER:============" + key));
                        SharedParamManager.removeCounter(key);
                        ++removedCounterCount;
                        continue;
                    }
                    if (nonTimestampAssociatedCountersCount >= ThrottleDistributedInstancesCleanupTask.this.maxNonAssociatedCounterCountToClear || !key.contains("sharedCounter-")) continue;
                    SharedParamManager.removeCounter(key);
                    log.debug((Object)("NON MATCHING COUNTER:============" + key));
                    ++nonTimestampAssociatedCountersCount;
                    ++removedCounterCount;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("TOTAL NUMBER OF ATOMIC LONGS BEFORE CLEANUP" + atomicLongCount));
                    log.debug((Object)("TOTAL NUMBER OF DISTRIBUTED COUNTER OBJECTS CLEARED " + removedCounterCount));
                    log.debug((Object)("TOTAL NUMBER OF DISTRIBUTED TIMESTAMP OBJECTS CLEARED " + removedAtomicTimestampCount));
                    log.debug((Object)("TOTAL NUMBER OF DISTRIBUTED OBJECTS AFTER CLEAN-UP" + hazelcastInstance.getDistributedObjects().size()));
                    log.debug((Object)("TOTAL NUMBER OF NON ASSOCIATED OBJECTS CLEANED" + nonTimestampAssociatedCountersCount));
                    long end = System.currentTimeMillis();
                    log.debug((Object)("TIME TAKEN FOR CLEANUP" + (end - start)));
                }
            }
        }
    }
}

