/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.CallerContext;
import org.apache.synapse.commons.throttle.core.SharedParamManager;
import org.apache.synapse.commons.throttle.core.ThrottleConfiguration;
import org.apache.synapse.commons.throttle.core.ThrottleDataHolder;
import org.apache.synapse.commons.throttle.core.ThrottleReplicator;
import org.apache.synapse.commons.throttle.core.ThrottleWindowReplicator;
import org.apache.synapse.commons.throttle.core.factory.ThrottleContextFactory;

public abstract class ThrottleContext {
    private static Log log = LogFactory.getLog((String)ThrottleContext.class.getName());
    private Map callersMap;
    private Map keyToTimeStampMap;
    private long nextCleanTime;
    private ThrottleConfiguration throttleConfiguration;
    private String throttleId;
    private ConfigurationContext configctx;
    private volatile ThrottleDataHolder dataHolder;
    private String keyPrefix;
    private boolean debugOn;
    private ThrottleReplicator throttleReplicator;
    private ThrottleWindowReplicator throttleWindowReplicator;

    public ThrottleContext(ThrottleConfiguration throttleConfiguration, ThrottleReplicator throttleReplicator) {
        if (throttleConfiguration == null) {
            throw new InstantiationError("Couldn't create the throttle context from null a throttle configuration");
        }
        this.throttleReplicator = throttleReplicator;
        this.keyToTimeStampMap = new ConcurrentHashMap();
        this.callersMap = new ConcurrentSkipListMap();
        this.nextCleanTime = 0L;
        this.throttleConfiguration = throttleConfiguration;
        this.debugOn = log.isDebugEnabled();
        this.throttleWindowReplicator = ThrottleContextFactory.getThrottleWindowReplicatorInstance();
        ThrottleContextFactory.getThrottleContextCleanupTaskInstance().addThrottleContext(this);
    }

    public ThrottleConfiguration getThrottleConfiguration() {
        return this.throttleConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallerContext getCallerContext(String id) {
        if (id != null) {
            Object co;
            if (this.debugOn) {
                log.debug((Object)("Found a configuration with id :" + id));
            }
            if (this.dataHolder != null && this.keyPrefix != null) {
                return this.dataHolder.getCallerContext(id);
            }
            Long timeKey = (Long)this.keyToTimeStampMap.get(id);
            if (timeKey != null && (co = this.callersMap.get(timeKey)) != null) {
                if (co instanceof CallerContext) {
                    return (CallerContext)co;
                }
                if (co instanceof LinkedList) {
                    LinkedList callers;
                    LinkedList linkedList = callers = (LinkedList)co;
                    synchronized (linkedList) {
                        for (CallerContext cc : callers) {
                            if (cc == null || !id.equals(cc.getId())) continue;
                            return cc;
                        }
                    }
                }
            }
        } else if (this.debugOn) {
            log.debug((Object)("Couldn't find a configuration for the remote caller : " + id));
        }
        return null;
    }

    public void addCallerContext(CallerContext callerContext, String id) {
        if (callerContext != null && id != null) {
            this.addCaller(callerContext, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCaller(CallerContext callerContext, String id) {
        Long time;
        if (this.debugOn) {
            log.debug((Object)("Setting the caller with an id " + id));
        }
        if (this.dataHolder != null && this.keyPrefix != null) {
            this.dataHolder.addCallerContext(id, callerContext);
        }
        if (!this.callersMap.containsKey(time = new Long(callerContext.getNextTimeWindow()))) {
            this.callersMap.put(time, callerContext);
        } else {
            Object callerObject = this.callersMap.get(time);
            if (callerObject != null) {
                if (callerObject instanceof CallerContext) {
                    LinkedList<Object> callersWithSameTimeStamp = new LinkedList<Object>();
                    callersWithSameTimeStamp.add(callerObject);
                    callersWithSameTimeStamp.add(callerContext);
                    this.callersMap.remove(time);
                    this.callersMap.put(time, callersWithSameTimeStamp);
                } else if (callerObject instanceof LinkedList) {
                    LinkedList callersWithSameTimeStamp;
                    LinkedList linkedList = callersWithSameTimeStamp = (LinkedList)callerObject;
                    synchronized (linkedList) {
                        callersWithSameTimeStamp.add(callerContext);
                    }
                }
            }
        }
        this.keyToTimeStampMap.put(id, time);
    }

    public void removeCallerContext(String id) {
        if (id != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("REMOVING CALLER CONTEXT WITH ID" + id));
            }
            this.removeCaller(id);
        }
    }

    private void removeCaller(String id) {
        Long time = (Long)this.keyToTimeStampMap.get(id);
        if (this.dataHolder != null && this.keyPrefix != null) {
            log.debug((Object)("Removing the caller with the configuration id " + id));
            this.dataHolder.removeCaller(id);
        }
        if (time != null) {
            this.callersMap.remove(time);
            this.keyToTimeStampMap.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processCleanList(long time) {
        if (this.debugOn) {
            log.debug((Object)"Cleaning up process is executing");
        }
        if (time > this.nextCleanTime) {
            SortedMap map = ((ConcurrentNavigableMap)this.callersMap).headMap(new Long(time));
            if (map != null && map.size() > 0) {
                for (Object o : map.values()) {
                    LinkedList callers;
                    if (o == null) continue;
                    if (o instanceof CallerContext) {
                        CallerContext c = (CallerContext)o;
                        String key = c.getId();
                        String role = c.getRoleId();
                        if (key != null) {
                            if (this.dataHolder != null && this.keyPrefix != null) {
                                c = this.dataHolder.getCallerContext(key);
                            }
                            if (c != null) {
                                c.cleanUpCallers(this.throttleConfiguration.getCallerConfiguration(role), this, time);
                            }
                        }
                    }
                    if (!(o instanceof LinkedList)) continue;
                    LinkedList linkedList = callers = (LinkedList)o;
                    synchronized (linkedList) {
                        for (CallerContext c : callers) {
                            String key = c.getId();
                            String role = c.getRoleId();
                            if (key == null) continue;
                            if (this.dataHolder != null && this.keyPrefix != null) {
                                c = this.dataHolder.getCallerContext(key);
                            }
                            if (c == null) continue;
                            c.cleanUpCallers(this.throttleConfiguration.getCallerConfiguration(role), this, time);
                        }
                    }
                }
            }
            this.nextCleanTime = time + 300000L;
        }
    }

    public void setThrottleId(String throttleId) {
        if (throttleId == null) {
            throw new IllegalArgumentException("The throttle id cannot be null");
        }
        this.throttleId = throttleId;
        this.keyPrefix = "throttle_" + throttleId;
    }

    public String getThrottleId() {
        return this.throttleId;
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configctx;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configctx = configurationContext;
        if (this.dataHolder == null) {
            this.initDataHolder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDataHolder() {
        if (this.configctx != null && this.dataHolder == null) {
            this.dataHolder = (ThrottleDataHolder)this.configctx.getPropertyNonReplicable("throttle_info");
            ConfigurationContext configurationContext = this.configctx;
            synchronized (configurationContext) {
                if (this.dataHolder == null) {
                    this.dataHolder = new ThrottleDataHolder();
                    this.configctx.setNonReplicableProperty("throttle_info", (Object)this.dataHolder);
                }
            }
        }
    }

    public abstract int getType();

    public void addAndFlushCallerContext(CallerContext callerContext, String id) {
        if (callerContext != null && id != null) {
            this.addCaller(callerContext, id);
            this.replicateCaller(id);
        }
    }

    public void flushCallerContext(CallerContext callerContext, String id) {
        if (this.dataHolder != null && callerContext != null && id != null) {
            this.dataHolder.addCallerContext(id, callerContext);
            this.replicateCaller(id);
        }
    }

    public void removeAndFlushCaller(String id) {
        if (id != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("REMOVING AND FLUSHING CALLER CONTEXT WITH ID " + id));
            }
            this.removeCaller(id);
            this.replicateCaller(id);
        }
    }

    public void removeAndDestroyShareParamsOfCaller(String id) {
        if (id != null) {
            if (log.isDebugEnabled()) {
                log.info((Object)("REMOVE AND DESTROY OF SHARED PARAM OF CALLER WITH ID " + id));
            }
            this.removeCaller(id);
            SharedParamManager.removeTimestamp(id);
            SharedParamManager.removeCounter(id);
        }
    }

    private void replicateCaller(String id) {
        if (this.configctx != null && this.keyPrefix != null) {
            try {
                if (this.debugOn) {
                    log.debug((Object)("Going to replicate the states of the caller : " + id));
                }
                this.throttleReplicator.setConfigContext(this.configctx);
                this.throttleReplicator.add(id);
            }
            catch (Exception clusteringFault) {
                log.error((Object)"Error during the replicating states ", (Throwable)clusteringFault);
            }
        }
    }

    public void replicateTimeWindow(String id) {
        if (this.configctx != null && this.keyPrefix != null) {
            try {
                if (this.debugOn) {
                    log.debug((Object)("Going to replicate the time window states of the caller : " + id));
                }
                this.throttleWindowReplicator.setConfigContext(this.configctx);
                this.throttleWindowReplicator.add(id);
            }
            catch (Exception e) {
                log.error((Object)"Error during the replicating window change ", (Throwable)e);
            }
        }
    }

    public void cleanupCallers(long time) {
        SortedMap map = ((ConcurrentNavigableMap)this.callersMap).headMap(new Long(time));
        if (log.isDebugEnabled()) {
            log.debug((Object)("CallerMap Size before cleanup process : " + map.size()));
        }
        if (map != null && map.size() > 0) {
            for (Object o : map.values()) {
                if (o == null) continue;
                if (o instanceof CallerContext) {
                    CallerContext c = (CallerContext)o;
                    String key = c.getId();
                    String role = c.getRoleId();
                    if (key != null) {
                        if (this.dataHolder != null && this.keyPrefix != null) {
                            c = this.dataHolder.getCallerContext(key);
                        }
                        if (c != null) {
                            c.cleanUpCallers(this.throttleConfiguration.getCallerConfiguration(role), this, time);
                        }
                    }
                }
                if (!(o instanceof LinkedList)) continue;
                LinkedList callers = (LinkedList)o;
                for (CallerContext c : callers) {
                    String key = c.getId();
                    String role = c.getRoleId();
                    if (key == null) continue;
                    if (this.dataHolder != null && this.keyPrefix != null) {
                        c = this.dataHolder.getCallerContext(key);
                    }
                    if (c == null) continue;
                    c.cleanUpCallers(this.throttleConfiguration.getCallerConfiguration(role), this, time);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CallerMap Size after cleanup process : " + map.size()));
        }
    }
}

