/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import com.hazelcast.core.AsyncAtomicLong;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IFunction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.internal.ThrottleServiceDataHolder;

public class SharedParamManager {
    private static Map<String, Long> counters = new ConcurrentHashMap<String, Long>();
    private static Map<String, Long> timestamps = new ConcurrentHashMap<String, Long>();
    private static Log log = LogFactory.getLog((String)SharedParamManager.class.getName());

    public static long getDistributedCounter(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("GET TIMESTAMP WITH ID " + id));
        }
        id = "sharedCounter-" + id;
        HazelcastInstance hazelcastInstance = SharedParamManager.getHazelcastInstance();
        if (hazelcastInstance != null) {
            return hazelcastInstance.getAtomicLong(id).get();
        }
        Long counter = counters.get(id);
        if (counter != null) {
            return counter;
        }
        counters.put(id, 0L);
        return 0L;
    }

    public static void setDistributedCounter(String id, long value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SETTING COUNTER WITH ID " + id));
        }
        id = "sharedCounter-" + id;
        HazelcastInstance hazelcastInstance = SharedParamManager.getHazelcastInstance();
        if (hazelcastInstance != null) {
            hazelcastInstance.getAtomicLong(id).set(value);
        } else {
            counters.put(id, value);
        }
    }

    public static long addAndGetDistributedCounter(String id, long value) {
        HazelcastInstance hazelcastInstance = SharedParamManager.getHazelcastInstance();
        id = "sharedCounter-" + id;
        if (hazelcastInstance != null) {
            return hazelcastInstance.getAtomicLong(id).addAndGet(value);
        }
        long currentCount = counters.get(id);
        long updatedCount = currentCount + value;
        counters.put(id, updatedCount);
        return updatedCount;
    }

    public static long asyncGetAndAddDistributedCounter(String id, long value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ASYNC CREATING AND SETTING COUNTER WITH ID " + id));
        }
        id = "sharedCounter-" + id;
        HazelcastInstance hazelcastInstance = SharedParamManager.getHazelcastInstance();
        if (hazelcastInstance != null) {
            AsyncAtomicLong asyncAtomicLong = (AsyncAtomicLong)hazelcastInstance.getAtomicLong(id);
            long currentGlobalCounter = asyncAtomicLong.get();
            asyncAtomicLong.asyncAddAndGet(value);
            return currentGlobalCounter;
        }
        Long currentCount = counters.get(id);
        if (currentCount == null) {
            currentCount = 0L;
        }
        long updatedCount = currentCount + value;
        counters.put(id, updatedCount);
        return currentCount;
    }

    public static long asyncGetAndAlterDistributedCounter(String id, long value) {
        HazelcastInstance hazelcastInstance = SharedParamManager.getHazelcastInstance();
        id = "sharedCounter-" + id;
        if (hazelcastInstance != null) {
            AsyncAtomicLong asyncAtomicLong = (AsyncAtomicLong)hazelcastInstance.getAtomicLong(id);
            long currentGlobalCounter = asyncAtomicLong.get();
            asyncAtomicLong.asyncAlter((IFunction)new AddLocalCount(value));
            return currentGlobalCounter;
        }
        Long currentCount = counters.get(id);
        if (currentCount == null) {
            currentCount = 0L;
        }
        long updatedCount = currentCount + value;
        counters.put(id, updatedCount);
        return currentCount;
    }

    public static void removeCounter(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("REMOVING COUNTER WITH ID " + id));
        }
        id = "sharedCounter-" + id;
        HazelcastInstance hazelcastInstance = SharedParamManager.getHazelcastInstance();
        if (hazelcastInstance != null) {
            hazelcastInstance.getAtomicLong(id).destroy();
        } else {
            counters.remove(id);
        }
    }

    public static long getSharedTimestamp(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("GET TIMESTAMP WITH ID " + id));
        }
        String key = "startedTime-" + id;
        HazelcastInstance hazelcastInstance = SharedParamManager.getHazelcastInstance();
        if (hazelcastInstance != null) {
            return hazelcastInstance.getAtomicLong(key).get();
        }
        Long timestamp = timestamps.get(key);
        if (timestamp != null) {
            return timestamp;
        }
        timestamps.put(key, 0L);
        return 0L;
    }

    public static long getSharedTimestampWithFullId(String id) {
        HazelcastInstance hazelcastInstance;
        if (log.isDebugEnabled()) {
            log.info((Object)("GET TIMESTAMP WITH FULL ID " + id));
        }
        if ((hazelcastInstance = SharedParamManager.getHazelcastInstance()) != null) {
            return hazelcastInstance.getAtomicLong(id).get();
        }
        Long timestamp = timestamps.get(id);
        if (timestamp != null) {
            return timestamp;
        }
        timestamps.put(id, 0L);
        return 0L;
    }

    public static void setSharedTimestamp(String id, long timestamp) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SETTING TIMESTAMP WITH ID" + id));
        }
        String key = "startedTime-" + id;
        HazelcastInstance hazelcastInstance = SharedParamManager.getHazelcastInstance();
        if (hazelcastInstance != null) {
            hazelcastInstance.getAtomicLong(key).set(timestamp);
        } else {
            timestamps.put(id, timestamp);
        }
    }

    public static void removeTimestamp(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("REMOVING TIMESTAMP WITH ID " + id));
        }
        String key = "startedTime-" + id;
        HazelcastInstance hazelcastInstance = SharedParamManager.getHazelcastInstance();
        if (hazelcastInstance != null) {
            hazelcastInstance.getAtomicLong(key).destroy();
        } else {
            timestamps.remove(key);
        }
    }

    public static void removeTimestampWithFullId(String id) {
        HazelcastInstance hazelcastInstance;
        if (log.isDebugEnabled()) {
            log.info((Object)("REMOVING TIMESTAMP WITH FULL ID " + id));
        }
        if ((hazelcastInstance = SharedParamManager.getHazelcastInstance()) != null) {
            hazelcastInstance.getAtomicLong(id).destroy();
        } else {
            timestamps.remove(id);
        }
    }

    private static HazelcastInstance getHazelcastInstance() {
        return ThrottleServiceDataHolder.getInstance().getHazelCastInstance();
    }

    private static class AddLocalCount
    implements IFunction<Long, Long> {
        private long localCount;

        public AddLocalCount(long localCount) {
            this.localCount = localCount;
        }

        public Long apply(Long input) {
            return input + this.localCount;
        }
    }
}

