/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.ConcurrentAccessUpdateClusterMessage;

public class ConcurrentAccessReplicator {
    private static final Log log = LogFactory.getLog(ConcurrentAccessReplicator.class);
    private ConfigurationContext configContext;

    public ConcurrentAccessReplicator(ConfigurationContext configContext) {
        this.configContext = configContext;
    }

    public void replicate(String key, Boolean action) {
        block4: {
            try {
                ClusteringAgent clusteringAgent = this.configContext.getAxisConfiguration().getClusteringAgent();
                if (clusteringAgent != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Replicating ConcurrentAccessController " + key + " in a ClusterMessage."));
                    }
                    clusteringAgent.sendMessage((ClusteringMessage)new ConcurrentAccessUpdateClusterMessage(key, action), true);
                }
            }
            catch (ClusteringFault e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Could not replicate throttle data", (Throwable)e);
            }
        }
    }
}

