/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConcurrentAccessController
implements Serializable {
    private static Log log = LogFactory.getLog((String)ConcurrentAccessController.class.getName());
    private int limit;
    private AtomicInteger counter;
    private static final long serialVersionUID = -6857325377726757251L;

    public ConcurrentAccessController(int limit) {
        this.limit = limit;
        this.counter = new AtomicInteger(limit);
    }

    public int getAndDecrement() {
        if (this.counter.get() <= 0) {
            return 0;
        }
        return this.counter.getAndDecrement();
    }

    public int incrementAndGet() {
        if (this.counter.get() >= this.limit) {
            return this.limit;
        }
        return this.counter.incrementAndGet();
    }

    public int getLimit() {
        return this.limit;
    }

    public void set(int newValue) {
        this.counter.set(newValue);
        this.limit = newValue;
    }

    public void updateCounter(boolean isIncrement) {
        if (isIncrement) {
            this.incrementAndGet();
        } else {
            this.getAndDecrement();
        }
    }
}

