/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.throttle.core;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.throttle.core.CallerConfiguration;
import org.apache.synapse.commons.throttle.core.ThrottleContext;
import org.apache.synapse.commons.throttle.core.ThrottleException;

public abstract class CallerContext
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1652165180220263492L;
    private static Log log = LogFactory.getLog((String)CallerContext.class.getName());
    private long nextAccessTime = 0L;
    private long firstAccessTime = 0L;
    private long nextTimeWindow = 0L;
    private AtomicLong globalCount = new AtomicLong(0L);
    private String roleId;
    private long unitTime;
    private AtomicLong localCount = new AtomicLong(0L);
    private UUID uuid = UUID.randomUUID();
    private String id;

    public CallerContext clone() throws CloneNotSupportedException {
        super.clone();
        CallerContext clone = new CallerContext(this.id){

            @Override
            public int getType() {
                return CallerContext.this.getType();
            }
        };
        clone.nextAccessTime = this.nextAccessTime;
        clone.firstAccessTime = this.firstAccessTime;
        clone.nextTimeWindow = this.nextTimeWindow;
        clone.globalCount = new AtomicLong(this.globalCount.longValue());
        clone.localCount = new AtomicLong(this.localCount.longValue());
        clone.roleId = this.roleId;
        this.localCount.set(0L);
        return clone;
    }

    public CallerContext(String ID) {
        if (ID == null || "".equals(ID)) {
            throw new InstantiationError("Couldn't create a CallContext for an empty remote caller ID");
        }
        this.id = ID.trim();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getId() {
        return this.id;
    }

    private void initAccess(CallerConfiguration configuration, ThrottleContext throttleContext, long currentTime) {
        this.unitTime = configuration.getUnitTime();
        this.firstAccessTime = currentTime;
        this.nextTimeWindow = this.firstAccessTime + this.unitTime;
        this.roleId = configuration.getID();
        throttleContext.addCallerContext(this, this.id);
        throttleContext.replicateTimeWindow(this.id);
    }

    private boolean canAccessIfUnitTimeNotOver(CallerConfiguration configuration, ThrottleContext throttleContext, long currentTime) {
        boolean canAccess = false;
        int maxRequest = configuration.getMaximumRequestPerUnitTime();
        if (maxRequest != 0) {
            if (this.globalCount.get() + this.localCount.get() < (long)maxRequest) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallerContext Checking access if unit time is not over and less than max count>> Access allowed=" + maxRequest + " available=" + ((long)maxRequest - (this.globalCount.get() + this.localCount.get())) + " key=" + this.getId() + " currentGlobalCount=" + this.globalCount + " currentTime=" + currentTime + " nextTimeWindow=" + this.nextTimeWindow + " currentLocalCount=" + this.localCount + " Tier=" + configuration.getID() + " nextAccessTime=" + this.nextAccessTime));
                }
                canAccess = true;
                this.localCount.incrementAndGet();
                throttleContext.flushCallerContext(this, this.id);
            } else if (this.nextAccessTime == 0L) {
                long prohibitTime = configuration.getProhibitTimePeriod();
                this.nextAccessTime = prohibitTime == 0L ? this.firstAccessTime + configuration.getUnitTime() : currentTime + prohibitTime;
                if (log.isDebugEnabled()) {
                    String type = 0 == configuration.getType() ? "IP address" : "domain";
                    log.debug((Object)("Maximum Number of requests are reached for caller with " + type + " - " + this.id));
                }
                throttleContext.flushCallerContext(this, this.id);
            } else if (this.nextAccessTime <= currentTime) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallerContext Checking access if unit time is not over before time window exceed >> Access allowed=" + maxRequest + " available=" + ((long)maxRequest - (this.globalCount.get() + this.localCount.get())) + " key=" + this.getId() + " currentGlobalCount=" + this.globalCount + " currentTime=" + currentTime + " nextTimeWindow=" + this.nextTimeWindow + " currentLocalCount=" + this.localCount + " Tier=" + configuration.getID() + " nextAccessTime=" + this.nextAccessTime));
                }
                if (this.nextTimeWindow != 0L) {
                    throttleContext.removeCallerContext(this.id);
                }
                this.nextAccessTime = 0L;
                canAccess = true;
                this.globalCount.set(0L);
                this.localCount.set(1L);
                this.firstAccessTime = currentTime;
                this.nextTimeWindow = currentTime + configuration.getUnitTime();
                throttleContext.replicateTimeWindow(this.id);
                throttleContext.addAndFlushCallerContext(this, this.id);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Caller=" + this.getId() + " has reset counters and added for replication when unit time is not over"));
                }
            } else if (log.isDebugEnabled()) {
                String type = 0 == configuration.getType() ? "IP address" : "domain";
                log.debug((Object)("Prohibit period is not yet over for caller with " + type + " - " + this.id));
            }
        }
        return canAccess;
    }

    private boolean canAccessIfUnitTimeOver(CallerConfiguration configuration, ThrottleContext throttleContext, long currentTime) {
        boolean canAccess = false;
        int maxRequest = configuration.getMaximumRequestPerUnitTime();
        if (maxRequest != 0) {
            if (this.globalCount.get() + this.localCount.get() < (long)maxRequest) {
                if (this.nextTimeWindow != 0L) {
                    throttleContext.removeCallerContext(this.id);
                    this.globalCount.set(0L);
                    this.localCount.set(1L);
                    this.firstAccessTime = currentTime;
                    this.nextTimeWindow = currentTime + configuration.getUnitTime();
                    throttleContext.replicateTimeWindow(this.id);
                    throttleContext.addAndFlushCallerContext(this, this.id);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallerContext Checking access if unit time over next time window>> Access allowed=" + maxRequest + " available=" + ((long)maxRequest - (this.globalCount.get() + this.localCount.get())) + " key=" + this.getId() + " currentGlobalCount=" + this.globalCount + " currentTime=" + currentTime + " nextTimeWindow=" + this.nextTimeWindow + " currentLocalCount=" + this.localCount + " Tier=" + configuration.getID() + " nextAccessTime=" + this.nextAccessTime));
                }
                canAccess = true;
            } else if (this.nextAccessTime == 0L || this.nextAccessTime <= currentTime) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("CallerContext Checking access if unit time over>> Access allowed=" + maxRequest + " available=" + ((long)maxRequest - (this.globalCount.get() + this.localCount.get())) + " key=" + this.getId() + " currentGlobalCount=" + this.globalCount + " currentTime=" + currentTime + " nextTimeWindow=" + this.nextTimeWindow + " currentLocalCount=" + this.localCount + " Tier=" + configuration.getID() + " nextAccessTime=" + this.nextAccessTime));
                }
                if (this.nextTimeWindow != 0L) {
                    throttleContext.removeCallerContext(this.id);
                }
                this.nextAccessTime = 0L;
                canAccess = true;
                this.globalCount.set(0L);
                this.localCount.set(1L);
                this.firstAccessTime = currentTime;
                this.nextTimeWindow = currentTime + configuration.getUnitTime();
                throttleContext.replicateTimeWindow(this.id);
                throttleContext.addAndFlushCallerContext(this, this.id);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Caller=" + this.getId() + " has reset counters and added for replication when unit time is over"));
                }
            } else if (log.isDebugEnabled()) {
                String type = 0 == configuration.getType() ? "IP address" : "domain";
                log.debug((Object)("Even unit time has over , CallerContext in prohibit state :" + type + " - " + this.id));
            }
        }
        return canAccess;
    }

    public void cleanUpCallers(CallerConfiguration configuration, ThrottleContext throttleContext, long currentTime) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Cleaning up the inactive caller's states ... ");
        }
        if (configuration == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Couldn't find the configuration .");
            }
            return;
        }
        int maxRequest = configuration.getMaximumRequestPerUnitTime();
        if (maxRequest != 0) {
            if (this.globalCount.get() + this.localCount.get() <= (long)(maxRequest - 1)) {
                if (this.nextTimeWindow != 0L && this.nextTimeWindow < currentTime - this.unitTime) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Removing caller with id " + this.id));
                    }
                    throttleContext.removeAndDestroyShareParamsOfCaller(this.id);
                }
            } else if ((this.nextAccessTime == 0L || this.nextAccessTime < currentTime - this.unitTime) && this.nextTimeWindow != 0L && this.nextTimeWindow < currentTime - this.unitTime) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing caller with id " + this.id));
                }
                throttleContext.removeAndDestroyShareParamsOfCaller(this.id);
            }
        }
    }

    public boolean canAccess(ThrottleContext throttleContext, CallerConfiguration configuration, long currentTime) throws ThrottleException {
        if (configuration == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Couldn't find the configuration .");
            }
            return true;
        }
        if (configuration.getMaximumRequestPerUnitTime() < 0 || configuration.getUnitTime() <= 0L || configuration.getProhibitTimePeriod() < 0L) {
            throw new ThrottleException("Invalid Throttle Configuration");
        }
        if (this.firstAccessTime == 0L) {
            this.initAccess(configuration, throttleContext, currentTime);
        }
        boolean canAccess = this.nextTimeWindow > currentTime ? this.canAccessIfUnitTimeNotOver(configuration, throttleContext, currentTime) : this.canAccessIfUnitTimeOver(configuration, throttleContext, currentTime);
        return canAccess;
    }

    public long getNextTimeWindow() {
        return this.nextTimeWindow;
    }

    public void incrementGlobalCounter(int incrementBy) {
        this.globalCount.addAndGet(incrementBy);
    }

    public void incrementLocalCounter() {
        this.localCount.incrementAndGet();
    }

    public long getGlobalCounter() {
        return this.globalCount.get();
    }

    public void setGlobalCounter(long counter) {
        this.globalCount.set(counter);
    }

    public void setLocalCounter(long counter) {
        this.localCount.set(counter);
    }

    public long getLocalCounter() {
        return this.localCount.get();
    }

    public void resetLocalCounter() {
        this.localCount.set(0L);
    }

    public void resetGlobalCounter() {
        this.globalCount.set(0L);
    }

    public abstract int getType();

    public long getFirstAccessTime() {
        return this.firstAccessTime;
    }

    public void setFirstAccessTime(long firstAccessTime) {
        this.firstAccessTime = firstAccessTime;
    }

    public void setNextTimeWindow(long nextTimeWindow) {
        this.nextTimeWindow = nextTimeWindow;
    }

    public long getUnitTime() {
        return this.unitTime;
    }

    public void setUnitTime(long unitTime) {
        this.unitTime = unitTime;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }
}

