/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.templates.uri.parser;

import org.apache.synapse.commons.templates.uri.URITemplateException;

public class Variable {
    private String name;
    private int prefix = -1;

    public Variable(String value) throws URITemplateException {
        this.name = value;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (!this.isValid(value.charAt(i)) && ch != ':') {
                throw new URITemplateException("Invalid character: '" + ch + "' in expression");
            }
            if (ch != ':') continue;
            this.name = value.substring(0, i);
            this.prefix = Integer.parseInt(value.substring(i + 1));
            if (this.prefix > 0) break;
            throw new URITemplateException("Invalid variable prefix: " + this.prefix);
        }
    }

    private boolean isValid(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '-' || ch == '_';
    }

    public String getName() {
        return this.name;
    }

    public String modify(String value) {
        if (this.prefix > 0 && this.prefix < value.length()) {
            return value.substring(0, this.prefix);
        }
        return value;
    }

    public boolean checkModifier(String value) {
        if (this.prefix > 0) {
            return value.length() == this.prefix;
        }
        return true;
    }
}

