/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.templates.uri.parser;

import java.util.Map;
import org.apache.synapse.commons.templates.uri.URITemplateException;
import org.apache.synapse.commons.templates.uri.parser.SimpleStringExpression;
import org.apache.synapse.commons.templates.uri.parser.Variable;

public class ReservedStringExpression
extends SimpleStringExpression {
    public ReservedStringExpression(String token) throws URITemplateException {
        super(token);
    }

    @Override
    protected boolean isReserved(char ch) {
        return false;
    }

    @Override
    protected String encodeValue(String value) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (super.isReserved(ch)) {
                builder.append(ch);
                continue;
            }
            builder.append(super.encodeValue(String.valueOf(ch)));
        }
        return builder.toString();
    }

    @Override
    protected boolean setVariables(String expressionValue, Map<String, String> variables) {
        if (this.variableList.size() == 1) {
            Variable var = (Variable)this.variableList.get(0);
            String name = var.getName();
            String finalValue = this.decodeValue(expressionValue);
            if (variables.containsKey(name) && !finalValue.equals(variables.get(name))) {
                return false;
            }
            if (var.checkModifier(finalValue)) {
                variables.put(name, finalValue);
                return true;
            }
            return false;
        }
        return super.setVariables(expressionValue, variables);
    }
}

