/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.templates.uri.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.synapse.commons.templates.uri.URITemplateException;
import org.apache.synapse.commons.templates.uri.parser.Node;
import org.apache.synapse.commons.templates.uri.parser.Variable;

public abstract class Expression
extends Node {
    protected List<Variable> variableList = new ArrayList<Variable>(4);

    public Expression(String token) throws URITemplateException {
        super(token);
        int startIndex = 0;
        for (int i = 0; i < token.length(); ++i) {
            if (token.charAt(i) == ',') {
                if (startIndex == i) {
                    throw new URITemplateException("Illegal variable reference with zero length");
                }
                this.variableList.add(new Variable(token.substring(startIndex, i)));
                startIndex = i + 1;
                continue;
            }
            if (i != token.length() - 1 || startIndex >= token.length()) continue;
            this.variableList.add(new Variable(token.substring(startIndex, i + 1)));
        }
    }

    @Override
    String getToken() {
        String str = "{";
        boolean first = true;
        for (Variable var : this.variableList) {
            if (!first) {
                str = str + ",";
            } else {
                first = false;
            }
            str = str + var.getName();
        }
        str = str + "}";
        return str;
    }

    protected String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error while encoding value: " + value, e);
        }
    }

    protected String decodeValue(String value) {
        try {
            return URLDecoder.decode(value.replaceAll("\\+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error while encoding value: " + value, e);
        }
    }
}

