/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.json.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.ProcessingInstruction;
import org.apache.synapse.commons.staxon.core.event.SimpleXMLEventFactory;

class XMLMultipleProcessingInstructionHandler {
    private static final ProcessingInstruction MULTIPLE_PI = new SimpleXMLEventFactory().createProcessingInstruction("xml-multiple", null);
    private final StringBuilder path = new StringBuilder();
    private final Set<String> absoluteMultiplePaths = new HashSet<String>();
    private final List<String> relativeMultiplePaths = new ArrayList<String>();
    private final String[] names = new String[64];
    private final boolean matchRoot;
    private final boolean matchPrefixes;
    private final Pattern pathPattern;
    private final ProcessingInstructionWriter writer;
    private String previousSiblingName = null;
    private int depth = 0;

    XMLMultipleProcessingInstructionHandler(final XMLStreamWriter writer, boolean matchRoot, boolean matchPrefixes) {
        this(new ProcessingInstructionWriter(){

            @Override
            void add(ProcessingInstruction pi) throws XMLStreamException {
                if (pi.getData() == null) {
                    writer.writeProcessingInstruction(pi.getTarget());
                } else {
                    writer.writeProcessingInstruction(pi.getTarget(), pi.getData());
                }
            }
        }, matchRoot, matchPrefixes);
    }

    XMLMultipleProcessingInstructionHandler(final XMLEventWriter writer, boolean matchRoot, boolean matchPrefixes) {
        this(new ProcessingInstructionWriter(){

            @Override
            void add(ProcessingInstruction pi) throws XMLStreamException {
                writer.add(pi);
            }
        }, matchRoot, matchPrefixes);
    }

    private XMLMultipleProcessingInstructionHandler(ProcessingInstructionWriter writer, boolean matchRoot, boolean matchPrefixes) {
        this.matchRoot = matchRoot;
        this.matchPrefixes = matchPrefixes;
        this.writer = writer;
        String identifier = "\\w(-?\\w)*";
        String name = matchPrefixes ? "(" + identifier + ":)?" + identifier : identifier;
        this.pathPattern = Pattern.compile("/?" + name + "(/" + name + ")*");
    }

    private boolean matches() {
        if (this.absoluteMultiplePaths.contains(this.path.toString())) {
            return true;
        }
        if (!this.relativeMultiplePaths.isEmpty()) {
            for (String suffix : this.relativeMultiplePaths) {
                if (!this.path.toString().endsWith(suffix) || this.path.charAt(this.path.length() - suffix.length() - 1) != '/') continue;
                return true;
            }
        }
        return false;
    }

    private void push(String name) throws XMLStreamException {
        if (this.matchRoot || this.depth > 0) {
            this.path.append('/').append(name);
        }
        if (!name.equals(this.previousSiblingName) && this.matches()) {
            this.writer.add(MULTIPLE_PI);
        }
        this.names[this.depth] = name;
        this.previousSiblingName = null;
        ++this.depth;
    }

    private void pop() {
        --this.depth;
        this.previousSiblingName = this.names[this.depth];
        this.names[this.depth] = null;
        if (this.matchRoot || this.depth > 0) {
            this.path.setLength(this.path.length() - this.previousSiblingName.length() - 1);
        }
    }

    void addMultiplePath(String path) throws XMLStreamException {
        if (!this.pathPattern.matcher(path).matches()) {
            throw new XMLStreamException("multiple path does not match " + this.pathPattern.pattern());
        }
        if (path.charAt(0) == '/') {
            this.absoluteMultiplePaths.add(path);
        } else {
            this.relativeMultiplePaths.add(path);
        }
    }

    void preStartElement(String prefix, String localPart) throws XMLStreamException {
        if (this.matchPrefixes) {
            this.push("".equals(prefix) ? localPart : prefix + ':' + localPart);
        } else {
            this.push(localPart);
        }
    }

    void postStartElement() throws XMLStreamException {
    }

    void preEndElement() throws XMLStreamException {
    }

    void postEndElement() throws XMLStreamException {
        this.pop();
    }

    void preEmptyElement(String prefix, String localPart) throws XMLStreamException {
        this.preStartElement(prefix, localPart);
    }

    void postEmptyElement() throws XMLStreamException {
        this.postStartElement();
        this.preEndElement();
        this.postEndElement();
    }

    private static abstract class ProcessingInstructionWriter {
        private ProcessingInstructionWriter() {
        }

        abstract void add(ProcessingInstruction var1) throws XMLStreamException;
    }
}

