/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.json.stream.util;

import java.io.IOException;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamSource;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamTarget;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamToken;

public class StreamSourceDelegate
implements JsonStreamSource {
    private final JsonStreamSource delegate;

    public StreamSourceDelegate(JsonStreamSource delegate) {
        this.delegate = delegate;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public int getLineNumber() {
        return this.delegate.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.delegate.getColumnNumber();
    }

    @Override
    public String name() throws IOException {
        return this.delegate.name();
    }

    @Override
    public int getCharacterOffset() {
        return this.delegate.getCharacterOffset();
    }

    @Override
    public JsonStreamSource.Value value() throws IOException {
        return this.delegate.value();
    }

    @Override
    public void startObject() throws IOException {
        this.delegate.startObject();
    }

    @Override
    public String getPublicId() {
        return this.delegate.getPublicId();
    }

    @Override
    public void endObject() throws IOException {
        this.delegate.endObject();
    }

    @Override
    public String getSystemId() {
        return this.delegate.getSystemId();
    }

    @Override
    public void startArray() throws IOException {
        this.delegate.startArray();
    }

    @Override
    public void endArray() throws IOException {
        this.delegate.endArray();
    }

    @Override
    public JsonStreamToken peek() throws IOException {
        return this.delegate.peek();
    }

    public void copy(JsonStreamTarget target) throws IOException {
        while (true) {
            switch (this.delegate.peek()) {
                case START_OBJECT: {
                    this.delegate.startObject();
                    target.startObject();
                    break;
                }
                case END_OBJECT: {
                    this.delegate.endObject();
                    target.endObject();
                    break;
                }
                case START_ARRAY: {
                    this.delegate.startArray();
                    target.startArray();
                    break;
                }
                case END_ARRAY: {
                    this.delegate.endArray();
                    target.endArray();
                    break;
                }
                case NAME: {
                    target.name(this.delegate.name());
                    break;
                }
                case VALUE: {
                    target.value(this.delegate.value().data);
                    break;
                }
                case NONE: {
                    return;
                }
            }
        }
    }
}

