/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.json.stream.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamTarget;
import org.apache.synapse.commons.staxon.core.json.stream.util.StreamTargetDelegate;

public class CustomRegexMatchReplaceIgnoreAutoPrimitiveTarget
extends StreamTargetDelegate {
    private final Pattern number = Pattern.compile("^-?(0|[1-9][0-9]*)(\\.[0-9]+)?([eE][+-]?[0-9]+)?$");
    private final boolean convertAttributes;
    private final Pattern customReplaceRegex;
    private final String customReplaceSequence;
    private String lastName;

    public CustomRegexMatchReplaceIgnoreAutoPrimitiveTarget(JsonStreamTarget delegate, boolean convertAttributes, String customReplaceRegex, String customReplaceSequence) {
        super(delegate);
        this.convertAttributes = convertAttributes;
        this.customReplaceRegex = Pattern.compile(customReplaceRegex);
        this.customReplaceSequence = customReplaceSequence;
    }

    @Override
    public void name(String name) throws IOException {
        this.lastName = name;
        super.name(name);
    }

    @Override
    public void value(Object value) throws IOException {
        if (value instanceof String && (this.convertAttributes || !this.lastName.startsWith("@"))) {
            if (this.customReplaceRegex != null && this.customReplaceRegex.matcher(value.toString()).lookingAt()) {
                super.value(this.customReplaceRegex.matcher(value.toString()).replaceFirst(this.customReplaceSequence));
            } else if ("true".equals(value)) {
                super.value(Boolean.TRUE);
            } else if ("false".equals(value)) {
                super.value(Boolean.FALSE);
            } else if ("null".equals(value)) {
                super.value(null);
            } else if (this.number.matcher(value.toString()).matches()) {
                super.value(new BigDecimal(value.toString()));
            } else {
                super.value(value);
            }
        } else {
            super.value(value);
        }
    }
}

