/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.json.stream.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamTarget;
import org.apache.synapse.commons.staxon.core.json.stream.impl.JsonStreamSourceImpl;

class JsonStreamTargetImpl
implements JsonStreamTarget {
    private final Writer writer;
    private final int[] namePos = new int[64];
    private final int[] arrayPos = new int[64];
    private final StringBuilder buffer = new StringBuilder();
    private final boolean closeWriter;
    private final String[] indent;
    private final String space;
    private int depth = 0;
    private JsonStreamSourceImpl.Scanner.Symbol symbol = null;
    private Stack<Character> symbols = new Stack();
    private Stack<Boolean> objects = new Stack();

    JsonStreamTargetImpl(Writer writer, boolean closeWriter) {
        this(writer, closeWriter, null, null, null);
    }

    JsonStreamTargetImpl(Writer writer, boolean closeWriter, String prettySpace, String prettyIndent, String prettyNewline) {
        this.writer = writer;
        this.closeWriter = closeWriter;
        this.space = prettySpace;
        if (prettyIndent != null || prettyNewline != null) {
            this.indent = new String[64];
            StringBuilder builder = new StringBuilder();
            if (prettyNewline != null) {
                builder.append(prettyNewline);
            }
            for (int i = 0; i < 64; ++i) {
                this.indent[i] = builder.toString();
                if (prettyIndent == null) continue;
                builder.append(prettyIndent);
            }
        } else {
            this.indent = null;
        }
    }

    private String encode(String value) {
        this.buffer.setLength(0);
        block9: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': {
                    this.buffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    this.buffer.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    this.buffer.append("\\b");
                    continue block9;
                }
                case '\f': {
                    this.buffer.append("\\f");
                    continue block9;
                }
                case '\n': {
                    this.buffer.append("\\n");
                    continue block9;
                }
                case '\r': {
                    this.buffer.append("\\r");
                    continue block9;
                }
                case '\t': {
                    this.buffer.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        this.buffer.append(String.format("\\u%04X", c));
                        continue block9;
                    }
                    this.buffer.append(c);
                }
            }
        }
        return this.buffer.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.closeWriter) {
            this.writer.close();
        } else {
            this.writer.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void name(String name) throws IOException {
        if ("jsonEmpty".equals(name)) {
            this.writer.write(this.symbols.pop().charValue());
            this.objects.push(false);
            this.symbol = null;
            return;
        }
        if (this.symbol == JsonStreamSourceImpl.Scanner.Symbol.START_OBJECT) {
            this.symbol = null;
            if ("jsonArray".equals(name) || "jsonElement".equals(name) || "jsonObject".equals(name)) {
                this.symbols.pop();
                this.objects.push(true);
                return;
            }
            this.objects.push(false);
            this.writer.write(this.symbols.pop().charValue());
        }
        this.symbol = null;
        if (this.namePos[this.depth] > 1) {
            this.writer.write(44);
        }
        int n = this.depth;
        this.namePos[n] = this.namePos[n] + 1;
        if (this.indent != null) {
            this.writer.write(this.indent[this.depth]);
        } else if (this.space != null) {
            this.writer.write(this.space);
        }
        this.writer.write(34);
        this.writer.write(name);
        this.writer.write(34);
        if (this.space != null) {
            this.writer.write(this.space);
        }
        this.writer.write(58);
    }

    @Override
    public void value(Object value) throws IOException {
        this.symbol = null;
        if (this.arrayPos[this.depth] > 0) {
            if (this.arrayPos[this.depth] > 1) {
                this.writer.write(44);
            }
            int n = this.depth;
            this.arrayPos[n] = this.arrayPos[n] + 1;
        }
        if (this.space != null) {
            this.writer.write(this.space);
        }
        if (value == null) {
            this.writer.write("null");
        } else if (value instanceof String) {
            if ("_JsonScanner_EMPTY_OBJECT".equals(value)) {
                return;
            }
            this.writer.write(34);
            this.writer.write(this.encode((String)value));
            this.writer.write(34);
        } else {
            this.writer.write(value.toString());
        }
    }

    @Override
    public void startObject() throws IOException {
        if (this.arrayPos[this.depth] > 0) {
            if (this.arrayPos[this.depth] > 1) {
                this.writer.write(44);
            }
            int n = this.depth;
            this.arrayPos[n] = this.arrayPos[n] + 1;
        }
        if (this.space != null && (this.depth > 0 || this.arrayPos[this.depth] > 0)) {
            this.writer.write(this.space);
        }
        this.symbols.push(Character.valueOf('{'));
        this.symbol = JsonStreamSourceImpl.Scanner.Symbol.START_OBJECT;
        ++this.depth;
        this.namePos[this.depth] = 1;
    }

    @Override
    public void endObject() throws IOException {
        this.symbol = null;
        this.namePos[this.depth] = 0;
        --this.depth;
        boolean skipEndObject = this.objects.pop();
        if (skipEndObject) {
            return;
        }
        if (this.indent != null) {
            this.writer.write(this.indent[this.depth]);
        } else if (this.space != null) {
            this.writer.write(this.space);
        }
        this.writer.write(125);
        if (this.depth == 0) {
            this.writer.flush();
        }
    }

    @Override
    public void startArray() throws IOException {
        this.symbol = null;
        if (this.arrayPos[this.depth] > 0) {
            throw new IOException("Nested arrays are not supported!");
        }
        if (this.space != null && this.depth > 0) {
            this.writer.write(this.space);
        }
        this.writer.write(91);
        this.arrayPos[this.depth] = 1;
    }

    @Override
    public void endArray() throws IOException {
        this.symbol = null;
        this.arrayPos[this.depth] = 0;
        if (this.space != null) {
            this.writer.write(this.space);
        }
        this.writer.write(93);
    }
}

