/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.json.stream;

import java.io.Closeable;
import java.io.IOException;
import javax.xml.stream.Location;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamToken;

public interface JsonStreamSource
extends Closeable,
Location {
    public static final Value TRUE = new Value("true", Boolean.TRUE);
    public static final Value FALSE = new Value("false", Boolean.FALSE);
    public static final Value NULL = new Value(null, null);

    public String name() throws IOException;

    public Value value() throws IOException;

    public void startObject() throws IOException;

    public void endObject() throws IOException;

    public void startArray() throws IOException;

    public void endArray() throws IOException;

    public JsonStreamToken peek() throws IOException;

    public static class Value {
        public final String text;
        public final Object data;

        private Value(String text, Object data) {
            this.text = text;
            this.data = data;
        }

        public Value(String text, Number number) {
            this(text, (Object)number);
        }

        public Value(String text) {
            this(text, text);
        }

        public String toString() {
            return this.text == null ? "null" : this.text;
        }
    }
}

