/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.staxon.core.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.synapse.commons.staxon.core.base.AbstractXMLInputFactory;
import org.apache.synapse.commons.staxon.core.event.SimpleXMLEventReader;
import org.apache.synapse.commons.staxon.core.event.SimpleXMLFilteredEventReader;
import org.apache.synapse.commons.staxon.core.json.JsonXMLConfig;
import org.apache.synapse.commons.staxon.core.json.JsonXMLStreamReader;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamFactory;
import org.apache.synapse.commons.staxon.core.json.stream.JsonStreamSource;
import org.apache.synapse.commons.staxon.core.json.stream.impl.Constants;
import org.apache.synapse.commons.staxon.core.json.stream.util.AddRootSource;

public class JsonXMLInputFactory
extends AbstractXMLInputFactory {
    public static final String PROP_MULTIPLE_PI = "JsonXMLInputFactory.multiplePI";
    public static final String PROP_VIRTUAL_ROOT = "JsonXMLInputFactory.virtualRoot";
    public static final String PROP_NAMESPACE_SEPARATOR = "JsonXMLInputFactory.namespaceSeparator";
    private final JsonStreamFactory streamFactory;
    private boolean multiplePI;
    private QName virtualRoot;
    private char namespaceSeparator;
    private boolean xmlNilReadWriteEnabled;

    public JsonXMLInputFactory() throws FactoryConfigurationError {
        this(JsonXMLConfig.DEFAULT);
    }

    public JsonXMLInputFactory(JsonStreamFactory streamFactory) {
        this(JsonXMLConfig.DEFAULT, streamFactory);
    }

    public JsonXMLInputFactory(JsonXMLConfig config) throws FactoryConfigurationError {
        this(config, JsonStreamFactory.newFactory());
    }

    public JsonXMLInputFactory(JsonXMLConfig config, JsonStreamFactory streamFactory) {
        this.multiplePI = config.isMultiplePI();
        this.virtualRoot = config.getVirtualRoot();
        this.namespaceSeparator = config.getNamespaceSeparator();
        this.streamFactory = streamFactory;
        this.xmlNilReadWriteEnabled = config.isReadWriteXmlNil();
        super.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        super.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        super.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        super.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        super.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        super.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }

    private JsonStreamSource decorate(JsonStreamSource source) {
        if (this.virtualRoot != null) {
            source = new AddRootSource(source, this.virtualRoot, this.namespaceSeparator);
        }
        return source;
    }

    @Override
    public JsonXMLStreamReader createXMLStreamReader(InputStream stream, String encoding) throws XMLStreamException {
        try {
            return this.createXMLStreamReader(new InputStreamReader(stream, encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public JsonXMLStreamReader createXMLStreamReader(String systemId, InputStream stream) throws XMLStreamException {
        return this.createXMLStreamReader(stream);
    }

    @Override
    public JsonXMLStreamReader createXMLStreamReader(String systemId, Reader reader) throws XMLStreamException {
        return this.createXMLStreamReader(reader);
    }

    @Override
    public JsonXMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        try {
            return new JsonXMLStreamReader(this.decorate(this.streamFactory.createJsonStreamSource(reader)), this.multiplePI, this.namespaceSeparator, this.xmlNilReadWriteEnabled);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public JsonXMLStreamReader createXMLStreamReader(Reader reader, Constants.SCANNER scanner) throws XMLStreamException {
        try {
            return new JsonXMLStreamReader(this.decorate(this.streamFactory.createJsonStreamSource(reader, scanner)), this.multiplePI, this.namespaceSeparator, this.xmlNilReadWriteEnabled);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public JsonXMLStreamReader createXMLStreamReader(InputStream stream) throws XMLStreamException {
        try {
            return new JsonXMLStreamReader(this.decorate(this.streamFactory.createJsonStreamSource(stream)), this.multiplePI, this.namespaceSeparator, this.xmlNilReadWriteEnabled);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public JsonXMLStreamReader createXMLStreamReader(InputStream stream, Constants.SCANNER scanner) throws XMLStreamException {
        try {
            return new JsonXMLStreamReader(this.decorate(this.streamFactory.createJsonStreamSource(stream, scanner)), this.multiplePI, this.namespaceSeparator, this.xmlNilReadWriteEnabled);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    @Override
    public XMLEventReader createXMLEventReader(XMLStreamReader reader) throws XMLStreamException {
        if (this.getEventAllocator() == null) {
            return new SimpleXMLEventReader(reader);
        }
        return new SimpleXMLEventReader(reader, this.getEventAllocator().newInstance());
    }

    @Override
    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) throws XMLStreamException {
        return new SimpleXMLFilteredEventReader(reader, filter);
    }

    @Override
    public void setXMLResolver(XMLResolver resolver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setXMLReporter(XMLReporter reporter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPropertySupported(String name) {
        return super.isPropertySupported(name) || Arrays.asList(PROP_MULTIPLE_PI, PROP_VIRTUAL_ROOT, PROP_NAMESPACE_SEPARATOR).contains(name);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (super.isPropertySupported(name)) {
            return super.getProperty(name);
        }
        if (PROP_MULTIPLE_PI.equals(name)) {
            return this.multiplePI;
        }
        if (PROP_VIRTUAL_ROOT.equals(name)) {
            return this.virtualRoot;
        }
        if (PROP_NAMESPACE_SEPARATOR.equals(name)) {
            return Character.valueOf(this.namespaceSeparator);
        }
        throw new IllegalArgumentException("Unsupported property: " + name);
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if ("javax.xml.stream.isNamespaceAware".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if ("javax.xml.stream.isReplacingEntityReferences".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if ("javax.xml.stream.isSupportingExternalEntities".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if ("javax.xml.stream.isValidating".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if ("javax.xml.stream.supportDTD".equals(name)) {
            if (!this.getProperty(name).equals(value)) {
                throw new IllegalArgumentException("Cannot change property: " + name);
            }
        } else if (super.isPropertySupported(name)) {
            super.setProperty(name, value);
        } else if (PROP_MULTIPLE_PI.equals(name)) {
            this.multiplePI = (Boolean)value;
        } else if (PROP_VIRTUAL_ROOT.equals(name)) {
            this.virtualRoot = value instanceof String ? QName.valueOf((String)value) : (QName)value;
        } else if (PROP_NAMESPACE_SEPARATOR.equals(name)) {
            this.namespaceSeparator = ((Character)value).charValue();
        } else {
            throw new IllegalArgumentException("Unsupported property: " + name);
        }
    }
}

