/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json.jsonprocessor.validators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ParserException;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ValidatorException;
import org.apache.synapse.commons.json.jsonprocessor.utils.DataTypeConverter;
import org.apache.synapse.commons.json.jsonprocessor.utils.JsonProcessorUtils;

public class NumericValidator {
    private static final String INTEGER_STRING = "integer";
    private static final String MINIMUM_VALUE = "minimum";
    private static final String MAXIMUM_VALUE = "maximum";
    private static final String EXCLUSIVE_MINIMUM = "exclusiveMinimum";
    private static final String EXCLUSIVE_MAXIMUM = "exclusiveMaximum";
    private static final String MULTIPLE_OF = "multipleOf";

    private NumericValidator() {
    }

    public static JsonPrimitive validateNumeric(JsonObject inputObject, String value) throws ParserException, ValidatorException {
        if (value == null) {
            throw new ValidatorException("Expected a number but found null");
        }
        if (NumericValidator.isNumeric(value = JsonProcessorUtils.replaceEnclosingQuotes(value))) {
            JsonArray enumElements;
            String maximumString;
            String minimumString;
            String type = "";
            if (inputObject.has("type")) {
                if (inputObject.get("type").isJsonArray()) {
                    for (JsonElement typeValue : inputObject.get("type").getAsJsonArray()) {
                        type = type + JsonProcessorUtils.replaceEnclosingQuotes(typeValue.getAsString());
                    }
                } else {
                    type = JsonProcessorUtils.replaceEnclosingQuotes(inputObject.get("type").getAsString());
                }
            }
            Double doubleValue = DataTypeConverter.convertToDouble(value);
            if (inputObject.has(MULTIPLE_OF)) {
                Double multipleOf = DataTypeConverter.convertToDouble(JsonProcessorUtils.replaceEnclosingQuotes(inputObject.get(MULTIPLE_OF).getAsString()));
                if (doubleValue % multipleOf != 0.0) {
                    throw new ValidatorException("Number " + value + " is not a multiple of " + multipleOf + ". multipleOf constraint in " + inputObject.toString() + " is violated by the input " + value);
                }
            }
            if (inputObject.has(MINIMUM_VALUE) && !(minimumString = JsonProcessorUtils.replaceEnclosingQuotes(inputObject.get(MINIMUM_VALUE).getAsString())).isEmpty() && doubleValue < DataTypeConverter.convertToDouble(minimumString)) {
                throw new ValidatorException("Number " + value + " is less than the minimum allowed value. minimumValue constraint in " + inputObject.toString() + " is violated by the input : " + value);
            }
            if (inputObject.has(MAXIMUM_VALUE) && !(maximumString = JsonProcessorUtils.replaceEnclosingQuotes(inputObject.get(MAXIMUM_VALUE).getAsString())).isEmpty() && doubleValue > DataTypeConverter.convertToDouble(maximumString)) {
                throw new ValidatorException("Number " + value + " is greater than the maximum allowed value. maximumValue constraint in " + inputObject.toString() + " is violated by the input : " + value);
            }
            if (inputObject.has(EXCLUSIVE_MINIMUM) && !(minimumString = JsonProcessorUtils.replaceEnclosingQuotes(inputObject.get(EXCLUSIVE_MINIMUM).getAsString())).isEmpty() && doubleValue <= DataTypeConverter.convertToDouble(minimumString)) {
                throw new ValidatorException("Number " + value + " is less than the minimum allowed value. ExclusiveMinimum constraint in " + inputObject.toString() + " is violated by the input : " + value);
            }
            if (inputObject.has(EXCLUSIVE_MAXIMUM) && !(maximumString = JsonProcessorUtils.replaceEnclosingQuotes(inputObject.get(EXCLUSIVE_MAXIMUM).getAsString())).isEmpty() && doubleValue >= DataTypeConverter.convertToDouble(maximumString)) {
                throw new ValidatorException("Number " + value + " is greater than the maximum allowed value. ExclusiveMaximum constraint in " + inputObject.toString() + " is violated by the input : " + value);
            }
            if (inputObject.has("enum") && (enumElements = inputObject.getAsJsonArray("enum")).size() > 0 && !enumElements.contains((JsonElement)new JsonPrimitive((Number)doubleValue))) {
                throw new ValidatorException("Number \"" + value + "\" not contains any element from the enum. Input " + value + " not contains any value from the enum in " + inputObject.toString());
            }
            if (inputObject.has("const") && !doubleValue.equals(inputObject.getAsJsonPrimitive("const").getAsDouble())) {
                throw new ValidatorException("Number \"" + value + "\" is not equal to the const value input " + value + " not contains the const defined in " + inputObject.toString());
            }
            if (type.contains(INTEGER_STRING)) {
                return new JsonPrimitive((Number)DataTypeConverter.convertToInt(value));
            }
            return new JsonPrimitive((Number)doubleValue);
        }
        throw new ParserException("\"" + value + "\" is not a number. A number expected in the schema " + inputObject.toString() + " but received " + value);
    }

    private static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

