/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json.jsonprocessor.validators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ParserException;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ValidatorException;
import org.apache.synapse.commons.json.jsonprocessor.utils.DataTypeConverter;

public class BooleanValidator {
    private BooleanValidator() {
    }

    public static JsonPrimitive validateBoolean(JsonObject inputObject, String value) throws ValidatorException, ParserException {
        JsonArray enumElements;
        if (value == null) {
            throw new ValidatorException("Received null input to be validated with : " + inputObject.toString() + ". Expected a boolean but found null");
        }
        Boolean parsedValue = DataTypeConverter.convertToBoolean(value);
        if (inputObject.has("enum") && (enumElements = inputObject.getAsJsonArray("enum")).size() > 0 && !enumElements.contains((JsonElement)new JsonPrimitive(parsedValue))) {
            throw new ValidatorException("input \"" + value + "\" not contains any element from the enum  : " + enumElements.toString());
        }
        if (inputObject.has("const") && !parsedValue.equals(inputObject.getAsJsonPrimitive("const").getAsBoolean())) {
            throw new ValidatorException("String \"" + value + "\" is not equal to the const value");
        }
        return new JsonPrimitive(parsedValue);
    }
}

