/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json.jsonprocessor.validators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashSet;
import java.util.Map;
import org.apache.synapse.commons.json.jsonprocessor.constants.ValidatorConstants;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ParserException;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ValidatorException;
import org.apache.synapse.commons.json.jsonprocessor.utils.DataTypeConverter;
import org.apache.synapse.commons.json.jsonprocessor.utils.GSONDataTypeConverter;
import org.apache.synapse.commons.json.jsonprocessor.utils.JsonProcessorUtils;
import org.apache.synapse.commons.json.jsonprocessor.validators.BooleanValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.NullValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.NumericValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.ObjectValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.StringValidator;

public class ArrayValidator {
    private static final String MIN_ITEMS = "minItems";
    private static final String MAX_ITEMS = "maxItems";
    private static final String ITEMS = "items";
    private static final String UNIQUE_ITEMS = "uniqueItems";
    private static final String ADDITIONAL_ITEMS = "additionalItems";

    private ArrayValidator() {
    }

    public static JsonArray validateArray(Map.Entry<String, JsonElement> input, JsonObject schema) throws ValidatorException, ParserException {
        String maxItemsString;
        String minItemsString;
        String uniqueItemsString;
        int minItems = -1;
        int maxItems = -1;
        boolean uniqueItems = false;
        boolean notAllowAdditional = false;
        if (schema.has(UNIQUE_ITEMS) && !(uniqueItemsString = JsonProcessorUtils.replaceEnclosingQuotes(schema.get(UNIQUE_ITEMS).getAsString())).isEmpty()) {
            uniqueItems = DataTypeConverter.convertToBoolean(uniqueItemsString);
        }
        if (schema.has(MIN_ITEMS) && !(minItemsString = JsonProcessorUtils.replaceEnclosingQuotes(schema.get(MIN_ITEMS).getAsString())).isEmpty() && (minItems = DataTypeConverter.convertToInt(minItemsString)) < 0) {
            throw new ValidatorException("Invalid minItems constraint in the schema");
        }
        if (schema.has(MAX_ITEMS) && !(maxItemsString = JsonProcessorUtils.replaceEnclosingQuotes(schema.get(MAX_ITEMS).getAsString())).isEmpty() && (maxItems = DataTypeConverter.convertToInt(maxItemsString)) < 0) {
            throw new ValidatorException("Invalid maxItems constraint in the schema");
        }
        JsonObject additionalItemsSchema = null;
        if (schema.has(ADDITIONAL_ITEMS)) {
            JsonElement tempElement = schema.get(ADDITIONAL_ITEMS);
            if (tempElement.isJsonPrimitive() && !tempElement.getAsBoolean()) {
                notAllowAdditional = true;
            } else if (tempElement.isJsonObject() && !tempElement.getAsJsonObject().entrySet().isEmpty()) {
                StringBuffer jsonString = new StringBuffer("{\"type\": \"array\",\"items\": ");
                jsonString.append(schema.get(ADDITIONAL_ITEMS).toString());
                jsonString.append("}");
                JsonParser parser = new JsonParser();
                additionalItemsSchema = parser.parse(jsonString.toString()).getAsJsonObject();
            }
        }
        JsonArray inputArray = input.getValue().isJsonArray() ? input.getValue().getAsJsonArray() : ArrayValidator.singleElementArrayCorrection(input.getValue());
        ArrayValidator.doStructuralValidations(inputArray, minItems, maxItems, uniqueItems);
        if (schema.has(ITEMS)) {
            if (schema.get(ITEMS).isJsonArray()) {
                JsonArray schemaArray = schema.get(ITEMS).getAsJsonArray();
                ArrayValidator.processSchemaWithItemsArray(inputArray, schemaArray, additionalItemsSchema, notAllowAdditional);
            } else if (schema.get(ITEMS).isJsonObject()) {
                JsonObject schemaObject = schema.get(ITEMS).getAsJsonObject();
                ArrayValidator.processSchemaWithOneItem(inputArray, schemaObject);
            } else {
                throw new ValidatorException("Schema for Array is invalid. Should contain either JsonArray or JsonObject");
            }
        }
        return inputArray;
    }

    private static JsonArray singleElementArrayCorrection(JsonElement element) {
        JsonArray array = new JsonArray();
        array.add(element);
        return array;
    }

    private static void processSchemaWithItemsArray(JsonArray inputArray, JsonArray schemaArray, JsonObject additionalItemsSchema, boolean notAllowAdditional) throws ValidatorException, ParserException {
        if (notAllowAdditional && inputArray.size() > schemaArray.size()) {
            throw new ValidatorException("Array : " + inputArray.toString() + " has more items than allowed in the schema");
        }
        int i = 0;
        for (JsonElement element : schemaArray) {
            JsonObject tempObj = element.getAsJsonObject();
            if (!tempObj.entrySet().isEmpty()) {
                if (tempObj.has("type")) {
                    String type = JsonProcessorUtils.replaceEnclosingQuotes(tempObj.get("type").toString());
                    if (ValidatorConstants.BOOLEAN_KEYS.contains(type)) {
                        inputArray.set(i, (JsonElement)BooleanValidator.validateBoolean(tempObj, inputArray.get(i).getAsString()));
                    } else if (ValidatorConstants.NOMINAL_KEYS.contains(type)) {
                        inputArray.set(i, (JsonElement)StringValidator.validateNominal(tempObj, inputArray.get(i).getAsString()));
                    } else if (ValidatorConstants.NUMERIC_KEYS.contains(type)) {
                        inputArray.set(i, (JsonElement)NumericValidator.validateNumeric(tempObj, inputArray.get(i).getAsString()));
                    } else if (ValidatorConstants.ARRAY_KEYS.contains(type)) {
                        inputArray.set(i, (JsonElement)ArrayValidator.validateArray(GSONDataTypeConverter.getMapFromString(inputArray.get(i).toString()), tempObj));
                    } else if (ValidatorConstants.NULL_KEYS.contains(type)) {
                        if (inputArray.get(i) != null) {
                            NullValidator.validateNull(tempObj, inputArray.get(i).toString());
                        }
                        inputArray.set(i, (JsonElement)JsonNull.INSTANCE);
                    } else if (ValidatorConstants.OBJECT_KEYS.contains(type)) {
                        inputArray.set(i, (JsonElement)ObjectValidator.validateObject(inputArray.get(i).getAsJsonObject(), tempObj));
                    }
                } else {
                    throw new ValidatorException("Array items should contain a type declaration");
                }
            }
            ++i;
        }
        if (additionalItemsSchema != null && inputArray.size() > schemaArray.size()) {
            int j;
            JsonArray extraArray = new JsonArray();
            for (j = i; j < inputArray.size(); ++j) {
                extraArray.add(inputArray.get(j));
            }
            extraArray = ArrayValidator.validateArray(GSONDataTypeConverter.getMapFromJsonArray(extraArray), additionalItemsSchema);
            for (j = 0; j < extraArray.size(); ++j) {
                inputArray.set(i + j, extraArray.get(j));
            }
        }
    }

    private static void processSchemaWithOneItem(JsonArray inputArray, JsonObject schemaObject) throws ValidatorException, ParserException {
        if (schemaObject.has("type")) {
            String type = JsonProcessorUtils.replaceEnclosingQuotes(schemaObject.get("type").toString());
            int i = 0;
            if (ValidatorConstants.BOOLEAN_KEYS.contains(type)) {
                for (JsonElement element : inputArray) {
                    inputArray.set(i, (JsonElement)BooleanValidator.validateBoolean(schemaObject, element.getAsString()));
                    ++i;
                }
            } else if (ValidatorConstants.NUMERIC_KEYS.contains(type)) {
                for (JsonElement element : inputArray) {
                    inputArray.set(i, (JsonElement)NumericValidator.validateNumeric(schemaObject, element.getAsString()));
                    ++i;
                }
            } else if (ValidatorConstants.NOMINAL_KEYS.contains(type)) {
                for (JsonElement element : inputArray) {
                    inputArray.set(i, (JsonElement)StringValidator.validateNominal(schemaObject, element.getAsString()));
                    ++i;
                }
            } else if (ValidatorConstants.ARRAY_KEYS.contains(type)) {
                for (JsonElement element : inputArray) {
                    inputArray.set(i, (JsonElement)ArrayValidator.validateArray(GSONDataTypeConverter.getMapFromString(element.getAsString()), schemaObject));
                    ++i;
                }
            } else if (ValidatorConstants.OBJECT_KEYS.contains(type)) {
                for (JsonElement element : inputArray) {
                    inputArray.set(i, (JsonElement)ObjectValidator.validateObject(element.getAsJsonObject(), schemaObject));
                    ++i;
                }
            } else if (ValidatorConstants.NULL_KEYS.contains(type)) {
                for (JsonElement element : inputArray) {
                    if (element != null) {
                        NullValidator.validateNull(schemaObject, element.toString());
                    }
                    inputArray.set(i, (JsonElement)JsonNull.INSTANCE);
                    ++i;
                }
            } else {
                throw new ValidatorException("Schema for array must have a type declaration" + schemaObject.toString());
            }
        }
    }

    private static void doStructuralValidations(JsonArray inputArray, int minItems, int maxItems, boolean uniqueItems) throws ValidatorException {
        String errorMsg = "Error occurs while validating the structure of array : ";
        if (minItems != -1 && inputArray.size() < minItems) {
            throw new ValidatorException("Error occurs while validating the structure of array : " + inputArray.toString() + ". Array violated the minItems constraint");
        }
        if (maxItems != -1 && inputArray.size() > maxItems) {
            throw new ValidatorException("Error occurs while validating the structure of array : " + inputArray.toString() + ". Array violated the maxItems constraint");
        }
        if (uniqueItems) {
            HashSet<JsonElement> temporarySet = new HashSet<JsonElement>();
            for (JsonElement element : inputArray) {
                if (temporarySet.add(element)) continue;
                throw new ValidatorException("Error occurs while validating the structure of array : " + inputArray.toString() + ". Array violated the uniqueItems constraint");
            }
        }
    }
}

