/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json.jsonprocessor.utils;

import org.apache.synapse.commons.json.jsonprocessor.exceptions.ParserException;
import org.apache.synapse.commons.json.jsonprocessor.utils.JsonProcessorUtils;

public class DataTypeConverter {
    private DataTypeConverter() {
    }

    public static Boolean convertToBoolean(String value) throws ParserException {
        if (value != null && !value.isEmpty()) {
            if ((value = JsonProcessorUtils.replaceEnclosingQuotes(value)).equals("true") || value.equals("false")) {
                return Boolean.parseBoolean(value);
            }
            throw new ParserException("Cannot convert the sting : " + value + " to boolean");
        }
        throw new ParserException("Cannot convert an empty string to boolean");
    }

    public static int convertToInt(String value) throws ParserException {
        if (value != null && !value.isEmpty()) {
            value = JsonProcessorUtils.replaceEnclosingQuotes(value);
            try {
                return Integer.parseInt(value.trim());
            }
            catch (NumberFormatException nfe) {
                throw new ParserException("NumberFormatException: " + nfe.getMessage(), nfe);
            }
        }
        throw new ParserException("Empty value cannot convert to int");
    }

    public static double convertToDouble(String value) throws ParserException {
        if (value != null && !value.isEmpty()) {
            value = JsonProcessorUtils.replaceEnclosingQuotes(value);
            try {
                return Double.parseDouble(value.trim());
            }
            catch (NumberFormatException nfe) {
                throw new ParserException("NumberFormatException: " + nfe.getMessage(), nfe);
            }
        }
        throw new ParserException("Empty value cannot convert to double");
    }
}

