/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json.jsonprocessor.parser;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.synapse.commons.json.jsonprocessor.constants.ValidatorConstants;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ParserException;
import org.apache.synapse.commons.json.jsonprocessor.exceptions.ValidatorException;
import org.apache.synapse.commons.json.jsonprocessor.utils.GSONDataTypeConverter;
import org.apache.synapse.commons.json.jsonprocessor.utils.JsonProcessorUtils;
import org.apache.synapse.commons.json.jsonprocessor.validators.ArrayValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.BooleanValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.NullValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.NumericValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.ObjectValidator;
import org.apache.synapse.commons.json.jsonprocessor.validators.StringValidator;

public class JsonProcessor {
    private static JsonParser parser = new JsonParser();

    private JsonProcessor() {
    }

    public static String parseJson(String inputString, String inputSchema) throws ValidatorException, ParserException {
        if (StringUtils.isNotEmpty((String)inputString) && StringUtils.isNotEmpty((String)inputSchema)) {
            JsonElement schema;
            try {
                schema = parser.parse(inputSchema);
            }
            catch (JsonSyntaxException ex) {
                throw new ValidatorException("Invalid JSON schema", ex);
            }
            if (schema.isJsonObject()) {
                if (schema.toString().replaceAll("\\s+", "").equals("{}")) {
                    return inputString;
                }
            } else {
                if (schema.isJsonPrimitive()) {
                    boolean valid = schema.getAsBoolean();
                    if (valid) {
                        return inputString;
                    }
                    throw new ValidatorException("JSON schema is false, so all validations will fail");
                }
                throw new ValidatorException("JSON schema should be an object or boolean");
            }
            JsonObject schemaObject = schema.getAsJsonObject();
            return JsonProcessor.parseJson(inputString, schemaObject);
        }
        throw new ParserException("Input json and schema should not be null");
    }

    private static String parseJson(String inputString, Object schema) throws ValidatorException, ParserException {
        if (StringUtils.isNotEmpty((String)inputString) && schema instanceof JsonObject) {
            JsonPrimitive result = null;
            JsonObject schemaObject = (JsonObject)schema;
            if (((JsonObject)schema).has("type")) {
                String type = JsonProcessorUtils.replaceEnclosingQuotes(schemaObject.get("type").toString());
                if (ValidatorConstants.BOOLEAN_KEYS.contains(type)) {
                    result = BooleanValidator.validateBoolean(schemaObject, inputString);
                } else if (ValidatorConstants.NOMINAL_KEYS.contains(type)) {
                    result = StringValidator.validateNominal(schemaObject, inputString);
                } else if (ValidatorConstants.NUMERIC_KEYS.contains(type)) {
                    result = NumericValidator.validateNumeric(schemaObject, inputString);
                } else if (ValidatorConstants.ARRAY_KEYS.contains(type)) {
                    result = ArrayValidator.validateArray(GSONDataTypeConverter.getMapFromString(inputString), schemaObject);
                } else if (ValidatorConstants.NULL_KEYS.contains(type)) {
                    NullValidator.validateNull(schemaObject, inputString);
                    result = JsonNull.INSTANCE;
                } else if (ValidatorConstants.OBJECT_KEYS.contains(type)) {
                    JsonElement input = parser.parse(inputString);
                    if (input.isJsonObject()) {
                        result = ObjectValidator.validateObject(input.getAsJsonObject(), schemaObject);
                    } else {
                        throw new ValidatorException("Expected a JSON as input but found : " + inputString);
                    }
                }
                if (result != null) {
                    return result.toString();
                }
                return null;
            }
            throw new ValidatorException("JSON schema should contain a type declaration");
        }
        throw new ParserException("Input json and schema should not be null, schema should be a JSON object");
    }
}

