/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.json.JsonUtil;

public final class JsonStreamFormatter
implements MessageFormatter {
    private static final Log logger = LogFactory.getLog((String)JsonStreamFormatter.class.getName());

    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeTo(messageContext, format, baos, true);
        return baos.toByteArray();
    }

    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapActionString) {
        String contentType = (String)messageContext.getProperty("ContentType");
        String encoding = format.getCharSetEncoding();
        if (contentType == null) {
            contentType = (String)messageContext.getProperty("messageType");
        }
        String setEncoding = (String)messageContext.getProperty("setCharacterEncoding");
        if (encoding != null && !"false".equals(setEncoding) && contentType != null && !contentType.contains("charset")) {
            contentType = contentType + "; charset=" + encoding;
        }
        return contentType;
    }

    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream out, boolean preserve) throws AxisFault {
        if (preserve) {
            messageContext.setProperty("preserve.json.stream", (Object)true);
        }
        String encoding = "UTF-8";
        if (format != null) {
            encoding = format.getCharSetEncoding();
        }
        JsonUtil.writeAsJson(messageContext, out, encoding);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#writeTo. Wrote JSON payload to output stream. MessageID: " + messageContext.getMessageID()));
        }
    }

    public static void toJson(MessageContext messageContext, OutputStream out) throws AxisFault {
        JsonUtil.writeAsJson(messageContext, out);
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"#getTargetAddress. Not implemented. #getTargetAddress()");
        }
        return targetURL;
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat omOutputFormat, String s) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"#formatSOAPAction. Not implemented. #formatSOAPAction()");
        }
        return null;
    }
}

