/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.json.JsonUtil;

public final class JsonStreamBuilder
implements Builder {
    private static final Log logger = LogFactory.getLog((String)JsonStreamBuilder.class.getName());

    public OMElement processDocument(InputStream inputStream, String s, MessageContext messageContext) throws AxisFault {
        if (inputStream != null) {
            OMElement element = JsonUtil.getNewJsonPayload(messageContext, inputStream, false, false);
            if (element != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("#processDocument. Built JSON payload from JSON stream. MessageID: " + messageContext.getMessageID()));
                }
                return element;
            }
        } else {
            String requestURL;
            EndpointReference endpointReference = messageContext.getTo();
            if (endpointReference == null) {
                logger.error((Object)("#processDocument. Cannot build payload without a valid EPR. MessageID: " + messageContext.getMessageID()));
                throw new AxisFault("Cannot build payload without a valid EPR.");
            }
            try {
                requestURL = URIEncoderDecoder.decode((String)endpointReference.getAddress());
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)("#processDocument. Could not decode request URL. MessageID: " + messageContext.getMessageID()));
                throw new AxisFault("Could not decode request URL.", (Throwable)e);
            }
            int index = requestURL.indexOf(61);
            if (index > 0) {
                String jsonString = requestURL.substring(index + 1);
                messageContext.setProperty("JSON_STRING", (Object)jsonString);
                ByteArrayInputStream is = new ByteArrayInputStream(jsonString.getBytes());
                return this.processDocument(is, s, messageContext);
            }
            messageContext.setProperty("JSON_STRING", null);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#processDocument. No JSON payload found in request. MessageID: " + messageContext.getMessageID()));
        }
        SOAPFactory factory = OMAbstractFactory.getSOAP12Factory();
        return factory.getDefaultEnvelope();
    }
}

