/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.axis2.util.XMLChar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class JsonReaderDelegate
extends StreamReaderDelegate {
    private static final Log logger = LogFactory.getLog((String)JsonReaderDelegate.class.getName());
    private boolean buildValidNCNames;

    public JsonReaderDelegate(XMLStreamReader reader, boolean processNCNames) {
        super(reader);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#JsonReaderDelegate. Setting XMLStreamReader: " + reader.getClass().getName()));
        }
        this.buildValidNCNames = processNCNames;
    }

    @Override
    public String getLocalName() {
        String localName;
        String newName = localName = super.getLocalName();
        if (localName == null || "".equals(localName)) {
            return localName;
        }
        if (Character.isDigit(localName.charAt(0))) {
            newName = "_JsonReader_PD_" + localName;
        }
        if (localName.charAt(0) == '$') {
            newName = "_JsonReader_PS_" + localName.substring(1);
        }
        if (this.buildValidNCNames) {
            newName = this.toValidNCName(newName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#getLocalName. old=" + localName + ", new=" + newName));
        }
        return newName;
    }

    @Override
    public QName getName() {
        String newNameP;
        QName qName = super.getName();
        String localName = qName.getLocalPart();
        QName newName = qName;
        if (localName == null || "".equals(localName)) {
            return qName;
        }
        boolean checked = false;
        if (Character.isDigit(localName.charAt(0))) {
            localName = "_JsonReader_PD_" + localName;
            if (this.buildValidNCNames) {
                localName = this.toValidNCName(localName);
                checked = true;
            }
            newName = new QName(qName.getNamespaceURI(), localName, qName.getPrefix());
        }
        if (localName.charAt(0) == '$') {
            localName = "_JsonReader_PS_" + localName.substring(1);
            if (this.buildValidNCNames) {
                localName = this.toValidNCName(localName);
                checked = true;
            }
            newName = new QName(qName.getNamespaceURI(), localName, qName.getPrefix());
        }
        if (!checked && this.buildValidNCNames && !localName.equals(newNameP = this.toValidNCName(localName))) {
            newName = new QName(qName.getNamespaceURI(), newNameP, qName.getPrefix());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#getName. old=" + localName + ", new=" + newName.getLocalPart()));
        }
        return newName;
    }

    private String toValidNCName(String name) {
        char c;
        if (name == null || name.isEmpty()) {
            return name;
        }
        int i = 0;
        StringBuilder newName = new StringBuilder();
        while (i < name.length() && (c = name.charAt(i++)) != '\uffffffff') {
            if (!XMLChar.isNCName((int)c)) {
                newName.append("_JsonReader_").append((int)c).append('_');
                continue;
            }
            newName.append(c);
        }
        return name.length() == newName.length() ? name : newName.toString();
    }
}

