/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.json.JsonReaderDelegate;
import org.apache.synapse.commons.staxon.core.json.JsonXMLConfig;
import org.apache.synapse.commons.staxon.core.json.JsonXMLConfigBuilder;
import org.apache.synapse.commons.staxon.core.json.JsonXMLInputFactory;

final class JsonDataSourceImpl
implements OMDataSource {
    public static final String END_OBJECT = "}";
    public static final String END_ARRAY = "}}";
    public static final String EMPTY_OBJECT = "{}";
    public static final String WRAPPER_OBJECT = "{\"jsonObject\":";
    public static final String WRAPPER_ARRAY = "{\"jsonArray\":{\"jsonElement\":";
    private byte[] stream;
    private int offset = 0;
    private int length = 0;
    private boolean isObject = true;
    private static final JsonXMLConfig xmlConfig = new JsonXMLConfigBuilder().multiplePI(true).autoArray(true).autoPrimitive(true).namespaceDeclarations(false).build();
    private static final JsonXMLInputFactory xmlInputFactory = new JsonXMLInputFactory(xmlConfig);
    private static final JsonXMLConfig xmlConfigNoPIs = new JsonXMLConfigBuilder().multiplePI(false).autoArray(true).autoPrimitive(true).namespaceDeclarations(false).build();
    private static final JsonXMLInputFactory xmlInputFactoryNoPIs = new JsonXMLInputFactory(xmlConfigNoPIs);
    private static final Log logger = LogFactory.getLog((String)JsonDataSourceImpl.class.getName());

    public JsonDataSourceImpl(InputStream inputStream) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            int c;
            while ((c = inputStream.read()) != -1 && Character.isWhitespace((char)c)) {
            }
            ++this.length;
            if (c == 123) {
                stream.write(WRAPPER_OBJECT.getBytes());
                this.offset = WRAPPER_OBJECT.length();
            } else if (c == 91) {
                stream.write(WRAPPER_ARRAY.getBytes());
                this.isObject = false;
                this.offset = WRAPPER_ARRAY.length();
            } else {
                logger.error((Object)("Could not create a JSON data source from the input stream. Found '" + (char)c + "' at the start of the input stream."));
                this.stream = EMPTY_OBJECT.getBytes();
                return;
            }
            stream.write(c);
            while ((c = inputStream.read()) != -1) {
                stream.write(c);
                ++this.length;
            }
            if (this.isObject) {
                stream.write(END_OBJECT.getBytes());
            } else {
                stream.write(END_ARRAY.getBytes());
            }
            stream.flush();
            this.stream = stream.toByteArray();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Built JSON Data Source from the incoming stream.");
            }
        }
        catch (IOException e) {
            logger.error((Object)("Could not create a JSON data source from the input stream. " + e.getLocalizedMessage()));
            this.stream = EMPTY_OBJECT.getBytes();
            this.isObject = true;
        }
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            output.write(this.stream, this.offset, this.length);
        }
        catch (IOException e) {
            throw new OMException("Could not serialize payload. " + e.getLocalizedMessage());
        }
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            IOUtils.copy((InputStream)new ByteArrayInputStream(this.stream, this.offset, this.length), (Writer)writer);
        }
        catch (IOException e) {
            throw new OMException("Could not serialize payload. " + e.getLocalizedMessage());
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        XMLStreamReader reader = this.getReader();
        xmlWriter.writeStartDocument();
        block13: while (reader.hasNext()) {
            int x = reader.next();
            switch (x) {
                case 1: {
                    xmlWriter.writeStartElement(reader.getPrefix(), reader.getLocalName(), reader.getNamespaceURI());
                    int namespaceCount = reader.getNamespaceCount();
                    for (int i = namespaceCount - 1; i >= 0; --i) {
                        xmlWriter.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                    }
                    int attributeCount = reader.getAttributeCount();
                    for (int i = 0; i < attributeCount; ++i) {
                        xmlWriter.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    }
                    continue block13;
                }
                case 7: {
                    break;
                }
                case 4: {
                    xmlWriter.writeCharacters(reader.getText());
                    break;
                }
                case 12: {
                    xmlWriter.writeCData(reader.getText());
                    break;
                }
                case 2: {
                    xmlWriter.writeEndElement();
                    break;
                }
                case 8: {
                    xmlWriter.writeEndDocument();
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    xmlWriter.writeComment(reader.getText());
                    break;
                }
                case 11: {
                    xmlWriter.writeDTD(reader.getText());
                    break;
                }
                case 3: {
                    xmlWriter.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
                    break;
                }
                case 9: {
                    xmlWriter.writeEntityRef(reader.getLocalName());
                    break;
                }
                default: {
                    throw new OMException();
                }
            }
        }
        xmlWriter.writeEndDocument();
        xmlWriter.flush();
        xmlWriter.close();
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        return new JsonReaderDelegate(xmlInputFactory.createXMLStreamReader(new ByteArrayInputStream(this.stream)), false);
    }
}

