/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.json;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.json.JsonDataSourceImpl;
import org.apache.synapse.commons.json.JsonUtil;

final class JsonDataSource
implements OMDataSource {
    private static final Log logger = LogFactory.getLog((String)JsonDataSourceImpl.class.getName());
    private final InputStream inputStream;

    public JsonDataSource(InputStream inputStream) {
        if (inputStream instanceof BufferedInputStream) {
            this.inputStream = inputStream;
        } else if (inputStream != null) {
            this.inputStream = new BufferedInputStream(inputStream);
            this.inputStream.mark(Integer.MAX_VALUE);
        } else {
            this.inputStream = null;
            logger.error((Object)"#JsonDataSource. Created invalid JSON DataSource. No JSON input stream found.");
        }
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            if (format != null && format.getContentType() != null && format.getContentType().contains("xml")) {
                this.inputStream.reset();
                JsonUtil.toXml(this.inputStream, false).serialize(output, format);
                return;
            }
            this.inputStream.reset();
            IOUtils.copy((InputStream)this.inputStream, (OutputStream)output);
        }
        catch (IOException e) {
            logger.error((Object)("#serialize:OutputStream. Could not serialize JSON payload. Error>>> " + e.getLocalizedMessage()));
            throw new OMException("Could not serialize JSON payload.", (Throwable)e);
        }
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            if (format != null && format.getContentType() != null && format.getContentType().contains("xml")) {
                this.inputStream.reset();
                JsonUtil.toXml(this.inputStream, false).serialize(writer, format);
                return;
            }
            this.inputStream.reset();
            IOUtils.copy((InputStream)this.inputStream, (Writer)writer);
        }
        catch (IOException e) {
            logger.error((Object)("#serialize:Writer. Could not serialize JSON payload. Error>>> " + e.getLocalizedMessage()));
            throw new OMException("Could not serialize JSON payload.", (Throwable)e);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        XMLStreamReader reader = this.getReader();
        xmlWriter.writeStartDocument();
        block13: while (reader.hasNext()) {
            int x = reader.next();
            switch (x) {
                case 1: {
                    xmlWriter.writeStartElement(reader.getPrefix(), reader.getLocalName(), reader.getNamespaceURI());
                    int namespaceCount = reader.getNamespaceCount();
                    for (int i = namespaceCount - 1; i >= 0; --i) {
                        xmlWriter.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                    }
                    int attributeCount = reader.getAttributeCount();
                    for (int i = 0; i < attributeCount; ++i) {
                        xmlWriter.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    }
                    continue block13;
                }
                case 7: {
                    break;
                }
                case 4: {
                    xmlWriter.writeCharacters(reader.getText());
                    break;
                }
                case 12: {
                    xmlWriter.writeCData(reader.getText());
                    break;
                }
                case 2: {
                    xmlWriter.writeEndElement();
                    break;
                }
                case 8: {
                    xmlWriter.writeEndDocument();
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    xmlWriter.writeComment(reader.getText());
                    break;
                }
                case 11: {
                    xmlWriter.writeDTD(reader.getText());
                    break;
                }
                case 3: {
                    xmlWriter.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
                    break;
                }
                case 9: {
                    xmlWriter.writeEntityRef(reader.getLocalName());
                    break;
                }
                default: {
                    throw new OMException();
                }
            }
        }
        xmlWriter.writeEndDocument();
        xmlWriter.flush();
        xmlWriter.close();
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        try {
            this.inputStream.reset();
        }
        catch (IOException e) {
            logger.error((Object)("#getReader. Could not reuse JSON stream from JSON Data Source. Error>> " + e.getLocalizedMessage()));
            throw new XMLStreamException("Could not reuse JSON stream from JSON Data Source.", e);
        }
        return JsonUtil.getReader(this.inputStream, JsonUtil.isPiEnabled());
    }
}

