/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.producer;

import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.emulator.http.dsl.HttpProducerContext;
import org.apache.synapse.commons.emulator.http.dsl.dto.Cookie;
import org.apache.synapse.commons.emulator.http.dsl.dto.Header;
import org.apache.synapse.commons.emulator.http.dsl.dto.producer.IncomingMessage;

public class HttpRequestInformationProcessor {
    private static final Log log = LogFactory.getLog(HttpRequestInformationProcessor.class);

    public HttpRequest populateHttpRequest(HttpProducerContext producerContext, IncomingMessage incomingMessage) throws Exception {
        String uri = this.getURI(producerContext.getHost(), producerContext.getPort(), incomingMessage);
        URI requestUri = new URI(uri);
        producerContext.host(requestUri.getHost());
        String scheme = requestUri.getScheme();
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            log.error((Object)"Only HTTP(S) is supported.");
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, incomingMessage.getMethod(), requestUri.getRawPath());
        this.populateHeader((HttpRequest)request, requestUri.getHost(), incomingMessage);
        this.populateCookies((HttpRequest)request, incomingMessage);
        return request;
    }

    private void populateHeader(HttpRequest request, String host, IncomingMessage incomingMessage) {
        request.headers().set("Host", (Object)host);
        request.headers().set("Connection", (Object)"close");
        request.headers().set("Accept-Encoding", (Object)"gzip");
        if (incomingMessage.getBody() != null) {
            request.headers().set("Content-Length", (Object)incomingMessage.getBody().getBytes().length);
        }
        if (incomingMessage.getHeaders() != null) {
            for (Header header : incomingMessage.getHeaders()) {
                request.headers().set(header.getName(), (Object)header.getValue());
            }
        }
    }

    private void populateCookies(HttpRequest request, IncomingMessage incomingMessage) {
        if (incomingMessage.getCookies() != null) {
            DefaultCookie[] cookies = new DefaultCookie[incomingMessage.getCookies().size()];
            int i = 0;
            for (Cookie cookie : incomingMessage.getCookies()) {
                cookies[i++] = new DefaultCookie(cookie.getName(), cookie.getValue());
            }
            request.headers().set("Cookie", (Object)ClientCookieEncoder.STRICT.encode((io.netty.handler.codec.http.cookie.Cookie[])cookies));
        }
    }

    private String getURI(String host, int port, IncomingMessage incomingMessage) {
        String path = incomingMessage.getPath();
        String uri = host + ":" + port;
        uri = path.startsWith("/") ? uri + path : uri + "/" + path;
        return uri;
    }
}

