/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.producer;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.util.Map;
import org.apache.synapse.commons.emulator.core.EmulatorType;
import org.apache.synapse.commons.emulator.http.ChannelPipelineInitializer;
import org.apache.synapse.commons.emulator.http.dsl.HttpProducerContext;
import org.apache.synapse.commons.emulator.http.dsl.dto.producer.IncomingMessage;
import org.apache.synapse.commons.emulator.http.dsl.dto.producer.OutgoingMessage;
import org.apache.synapse.commons.emulator.http.producer.HttpRequestInformationProcessor;

public class HttpEmulatorProducerInitializer {
    private HttpProducerContext producerContext;
    private EventLoopGroup group;

    public HttpEmulatorProducerInitializer(HttpProducerContext producerContext) {
        this.producerContext = producerContext;
    }

    public void initialize() throws Exception {
        for (Map.Entry<IncomingMessage, OutgoingMessage> entry : this.producerContext.getInOutCorrelation().entrySet()) {
            this.sendMessage(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(IncomingMessage incomingMessage, OutgoingMessage outgoingMessage) throws Exception {
        boolean ssl = "https".equalsIgnoreCase(null);
        SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
        HttpRequest httpRequest = new HttpRequestInformationProcessor().populateHttpRequest(this.producerContext, incomingMessage);
        this.group = new NioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ChannelPipelineInitializer channelPipelineInitializer = new ChannelPipelineInitializer(sslCtx, EmulatorType.HTTP_PRODUCER);
            channelPipelineInitializer.setProducerOutgoingMessage(outgoingMessage);
            ((Bootstrap)((Bootstrap)b.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)channelPipelineInitializer);
            Channel ch = b.connect(this.producerContext.getHost(), this.producerContext.getPort().intValue()).sync().channel();
            ch.writeAndFlush((Object)httpRequest);
            ch.closeFuture().sync();
        }
        finally {
            this.group.shutdownGracefully();
        }
    }

    public void shutdown() {
        this.group.shutdownGracefully();
    }
}

