/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.dsl.dto.producer;

import io.netty.handler.codec.http.HttpMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.synapse.commons.emulator.http.dsl.dto.Cookie;
import org.apache.synapse.commons.emulator.http.dsl.dto.Header;
import org.apache.synapse.commons.emulator.http.dsl.dto.QueryParameter;

public class IncomingMessage {
    private static IncomingMessage incoming;
    private String path;
    private HttpMethod method;
    private String body;
    private List<Header> headers;
    private List<QueryParameter> queryParameters;
    private List<Cookie> cookies;

    private static IncomingMessage getInstance() {
        incoming = new IncomingMessage();
        return incoming;
    }

    public static IncomingMessage request() {
        return IncomingMessage.getInstance();
    }

    public IncomingMessage withMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public IncomingMessage withPath(String path) {
        this.path = path;
        return this;
    }

    public IncomingMessage withBody(String body) {
        this.body = body;
        return this;
    }

    public IncomingMessage withHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new ArrayList<Header>();
        }
        Header header = new Header(name, value);
        this.headers.add(header);
        return this;
    }

    public IncomingMessage withHeaders(Header ... headers) {
        this.headers = Arrays.asList(headers);
        return this;
    }

    public IncomingMessage withQueryParameter(String name, String value) {
        if (this.queryParameters == null) {
            this.queryParameters = new ArrayList<QueryParameter>();
        }
        this.queryParameters.add(new QueryParameter(name, value));
        return this;
    }

    public IncomingMessage withQueryParameters(QueryParameter ... queryParameters) {
        this.queryParameters = Arrays.asList(queryParameters);
        return this;
    }

    public IncomingMessage withCookie(String name, String value) {
        if (this.cookies == null) {
            this.cookies = new ArrayList<Cookie>();
        }
        this.cookies.add(new Cookie(name, value));
        return this;
    }

    public IncomingMessage withCookies(Cookie ... cookies) {
        this.cookies = Arrays.asList(cookies);
        return this;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public String getPath() {
        return this.path;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getBody() {
        return this.body;
    }

    public List<QueryParameter> getQueryParameters() {
        return this.queryParameters;
    }
}

