/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.dsl.dto.consumer;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.synapse.commons.emulator.http.dsl.dto.Cookie;
import org.apache.synapse.commons.emulator.http.dsl.dto.Header;

public class OutgoingMessage {
    private static OutgoingMessage outgoing;
    private HttpResponseStatus statusCode = HttpResponseStatus.OK;
    private List<Cookie> cookies;
    private List<Header> headers;
    private String body;

    private static OutgoingMessage getInstance() {
        outgoing = new OutgoingMessage();
        return outgoing;
    }

    public static OutgoingMessage response() {
        return OutgoingMessage.getInstance();
    }

    public OutgoingMessage withStatusCode(HttpResponseStatus statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public OutgoingMessage withCookie(String name, String value) {
        if (this.cookies == null) {
            this.cookies = new ArrayList<Cookie>();
        }
        this.cookies.add(new Cookie(name, value));
        return this;
    }

    public OutgoingMessage withCookies(Cookie ... cookies) {
        if (this.cookies == null) {
            this.cookies = new ArrayList<Cookie>();
        }
        if (cookies != null && cookies.length > 0) {
            this.cookies.addAll(Arrays.asList(cookies));
        }
        return this;
    }

    public OutgoingMessage withHeader(String name, String value) {
        if (this.headers == null) {
            this.headers = new ArrayList<Header>();
        }
        this.headers.add(new Header(name, value));
        return this;
    }

    public OutgoingMessage withHeaders(Header ... headers) {
        if (this.headers == null) {
            this.headers = new ArrayList<Header>();
        }
        if (headers != null && headers.length > 0) {
            this.headers.addAll(Arrays.asList(headers));
        }
        return this;
    }

    public OutgoingMessage withBody(String body) {
        this.body = body;
        return this;
    }

    public OutgoingMessage withEmptyBody() {
        return this;
    }

    public HttpResponseStatus getStatusCode() {
        return this.statusCode;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }
}

