/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.dsl.dto.consumer;

import io.netty.handler.codec.http.HttpMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.emulator.http.consumer.HttpRequestContext;
import org.apache.synapse.commons.emulator.http.dsl.dto.Header;
import org.apache.synapse.commons.emulator.http.dsl.dto.QueryParameter;

public class IncomingMessage {
    private static final Log logger = LogFactory.getLog((String)IncomingMessage.class.getName());
    private static IncomingMessage incoming;
    private HttpMethod method;
    private String path;
    private String body;
    private String context;
    private Pattern pathRegex;
    private Header header;
    private List<QueryParameter> queryParameters;

    private static IncomingMessage getInstance() {
        incoming = new IncomingMessage();
        return incoming;
    }

    public static IncomingMessage request() {
        return IncomingMessage.getInstance();
    }

    public IncomingMessage withMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public IncomingMessage withPath(String path) {
        this.path = path;
        return this;
    }

    public IncomingMessage withBody(String body) {
        this.body = body;
        return this;
    }

    public IncomingMessage withHeader(String name, String value) {
        this.header = new Header(name, value);
        return this;
    }

    public IncomingMessage withQueryParameter(String name, String value) {
        if (this.queryParameters == null) {
            this.queryParameters = new ArrayList<QueryParameter>();
        }
        this.queryParameters.add(new QueryParameter(name, value));
        return this;
    }

    public boolean isMatch(HttpRequestContext requestContext) {
        return this.isContextMatch(requestContext) && this.isHttpMethodMatch(requestContext) && this.isRequestContentMatch(requestContext) && this.isHeadersMatch(requestContext) && this.isQueryParameterMatch(requestContext);
    }

    public void buildPathRegex(String context) {
        this.context = context;
        String regex = this.buildRegex(context, this.path);
        this.pathRegex = Pattern.compile(regex);
    }

    private boolean isContextMatch(HttpRequestContext requestContext) {
        this.context = this.extractContext(requestContext.getUri());
        return this.pathRegex.matcher(this.context).find();
    }

    private boolean isHttpMethodMatch(HttpRequestContext requestContext) {
        if (this.method == null) {
            return true;
        }
        if (this.method.equals((Object)requestContext.getHttpMethod())) {
            return true;
        }
        logger.error((Object)("Incoming request's service method '" + requestContext.getHttpMethod() + "' is not matched with the expected service method '" + this.method + "' for the mock service path " + this.context.substring(0, this.context.length() - 1) + this.path));
        return false;
    }

    private boolean isRequestContentMatch(HttpRequestContext requestContext) {
        if (this.body == null || this.body.isEmpty()) {
            return true;
        }
        if (this.body.equalsIgnoreCase(requestContext.getRequestBody())) {
            return true;
        }
        String servicePath = this.context.substring(0, this.context.length() - 1) + this.path;
        logger.error((Object)"Incoming request and expected request payloads are not matched");
        logger.error((Object)("Incoming request payload for the mock service path " + servicePath + " is - " + requestContext.getRequestBody()));
        logger.error((Object)("Expected request payload for the mock service path " + servicePath + " is - " + this.body));
        return false;
    }

    private boolean isHeadersMatch(HttpRequestContext requestContext) {
        if (this.header == null) {
            return true;
        }
        Map<String, List<String>> headerParameters = requestContext.getHeaderParameters();
        List<String> headerValues = headerParameters.get(this.header.getName());
        if (headerParameters == null || headerValues == null || headerValues.isEmpty()) {
            return false;
        }
        for (String value : headerValues) {
            if (!value.equalsIgnoreCase(this.header.getValue())) continue;
            return true;
        }
        logger.error((Object)("Could not find expected request header " + this.header.getName() + ":" + this.header.getValue() + " in incoming header list for the mock service path " + this.context.substring(0, this.context.length() - 1) + this.path));
        return false;
    }

    private boolean isQueryParameterMatch(HttpRequestContext requestContext) {
        Map<String, List<String>> requestQueryParameters = requestContext.getQueryParameters();
        if ((this.queryParameters == null || this.queryParameters.isEmpty()) && (requestQueryParameters == null || requestQueryParameters.isEmpty())) {
            return true;
        }
        if (this.queryParameters == null || this.queryParameters.isEmpty() || this.queryParameters.size() != requestQueryParameters.size()) {
            return false;
        }
        for (QueryParameter definedQueryParams : this.queryParameters) {
            if (!requestQueryParameters.containsKey(definedQueryParams.getName())) {
                return false;
            }
            List<String> queryValues = requestQueryParameters.get(definedQueryParams.getName());
            if (queryValues == null || queryValues.isEmpty()) {
                return false;
            }
            for (String value : queryValues) {
                if (value.equalsIgnoreCase(definedQueryParams.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    private String buildRegex(String context, String path) {
        String fullPath = "";
        if ((context == null || context.isEmpty()) && (path == null || path.isEmpty())) {
            return ".*";
        }
        if (context != null && !context.isEmpty()) {
            fullPath = context;
            if (!fullPath.startsWith("/")) {
                fullPath = "/" + fullPath;
            }
            if (!fullPath.endsWith("/")) {
                fullPath = fullPath + "/";
            }
        } else {
            fullPath = ".*";
        }
        fullPath = path != null && !path.isEmpty() ? (fullPath.endsWith("/") && path.startsWith("/") ? fullPath + path.substring(1) : (fullPath.endsWith("/") && !path.startsWith("/") ? fullPath + path : (!fullPath.endsWith("/") && path.startsWith("/") ? fullPath + path : fullPath + "/" + path))) : fullPath + ".*";
        if (fullPath.endsWith("/")) {
            fullPath = fullPath.substring(0, fullPath.length() - 1);
        }
        return "^" + fullPath + "/$";
    }

    private String extractContext(String uri) {
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        if (!uri.contains("?")) {
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            return uri;
        }
        if (!(uri = uri.split("\\?")[0]).endsWith("/")) {
            uri = uri + "/";
        }
        return uri;
    }
}

