/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.dsl;

import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpVersion;
import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.commons.emulator.core.AbstractEmulatorContext;
import org.apache.synapse.commons.emulator.core.AbstractProtocolEmulator;
import org.apache.synapse.commons.emulator.http.HTTPProtocolEmulator;
import org.apache.synapse.commons.emulator.http.dsl.dto.consumer.IncomingMessage;
import org.apache.synapse.commons.emulator.http.dsl.dto.consumer.OutgoingMessage;

public class HttpConsumerContext
extends AbstractEmulatorContext {
    private String context;
    private int readingDelay;
    private int writingDelay;
    private boolean randomConnectionClose;
    private HttpVersion httpVersion;
    private IncomingMessage incoming;
    private ChannelInboundHandlerAdapter logicHandler;
    private Map<IncomingMessage, OutgoingMessage> inOutCorrelation = new HashMap<IncomingMessage, OutgoingMessage>();
    private HTTPProtocolEmulator httpProtocolEmulator;

    public HttpConsumerContext(HTTPProtocolEmulator httpProtocolEmulator) {
        this.httpProtocolEmulator = httpProtocolEmulator;
        this.httpVersion = HttpVersion.HTTP_1_1;
    }

    @Override
    public HttpConsumerContext host(String host) {
        super.host(host);
        return this;
    }

    @Override
    public HttpConsumerContext port(int port) {
        super.port(port);
        return this;
    }

    public HttpConsumerContext context(String context) {
        this.context = context;
        return this;
    }

    public HttpConsumerContext readingDelay(int readingDelay) {
        this.readingDelay = readingDelay;
        return this;
    }

    public HttpConsumerContext writingDelay(int writingDelay) {
        this.writingDelay = writingDelay;
        return this;
    }

    public HttpConsumerContext randomConnectionClose(boolean randomConnectionClose) {
        this.randomConnectionClose = randomConnectionClose;
        return this;
    }

    public HttpConsumerContext httpVersion(HttpVersion httpVersion) {
        this.httpVersion = httpVersion;
        return this;
    }

    public HttpConsumerContext when(IncomingMessage incoming) {
        this.incoming = incoming;
        this.incoming.buildPathRegex(this.context);
        return this;
    }

    public HttpConsumerContext logic(ChannelInboundHandlerAdapter logicHandler) {
        this.logicHandler = logicHandler;
        return this;
    }

    public HttpConsumerContext respond(OutgoingMessage outgoing) {
        this.inOutCorrelation.put(this.incoming, outgoing);
        return this;
    }

    public AbstractProtocolEmulator operations() {
        return this.httpProtocolEmulator;
    }

    public String getContext() {
        return this.context;
    }

    public int getReadingDelay() {
        return this.readingDelay;
    }

    public int getWritingDelay() {
        return this.writingDelay;
    }

    public boolean isRandomConnectionClose() {
        return this.randomConnectionClose;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public ChannelInboundHandlerAdapter getLogicHandler() {
        return this.logicHandler;
    }

    public IncomingMessage getIncoming() {
        return this.incoming;
    }

    public Map<IncomingMessage, OutgoingMessage> getInOutCorrelation() {
        return this.inOutCorrelation;
    }
}

