/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.consumer;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.ServerCookieEncoder;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.synapse.commons.emulator.http.consumer.HttpRequestContext;
import org.apache.synapse.commons.emulator.http.dsl.HttpConsumerContext;
import org.apache.synapse.commons.emulator.http.dsl.dto.Cookie;
import org.apache.synapse.commons.emulator.http.dsl.dto.Header;
import org.apache.synapse.commons.emulator.http.dsl.dto.consumer.IncomingMessage;
import org.apache.synapse.commons.emulator.http.dsl.dto.consumer.OutgoingMessage;

public class HttpResponseProcessor {
    private HttpConsumerContext consumerContext;

    public HttpResponseProcessor(HttpConsumerContext consumerContext) {
        this.consumerContext = consumerContext;
    }

    public void process(HttpRequestContext requestContext, ChannelHandlerContext ctx) {
        OutgoingMessage outgoing = this.getMatchResource(requestContext);
        if (outgoing == null) {
            if (!this.write404NotFoundResponse(requestContext, ctx)) {
                ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        } else if (!this.writeResponse(requestContext, outgoing, ctx)) {
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private boolean writeResponse(HttpRequestContext requestContext, OutgoingMessage outgoing, ChannelHandlerContext ctx) {
        boolean keepAlive = requestContext.isKeepAlive();
        HttpVersion httpVersion = this.consumerContext.getHttpVersion();
        HttpResponseStatus httpResponseStatus = outgoing.getStatusCode();
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpVersion, httpResponseStatus, Unpooled.copiedBuffer((CharSequence)outgoing.getBody(), (Charset)CharsetUtil.UTF_8));
        this.populateHttpHeaders((FullHttpResponse)response, outgoing);
        this.populateCookies((FullHttpResponse)response, outgoing);
        if (!keepAlive) {
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            response.headers().set("Connection", (Object)"keep-alive");
            ctx.write((Object)response);
        }
        return keepAlive;
    }

    private void populateHttpHeaders(FullHttpResponse response, OutgoingMessage outgoing) {
        if (outgoing.getHeaders() != null) {
            for (Header header : outgoing.getHeaders()) {
                response.headers().add(header.getName(), (Object)header.getValue());
            }
        }
        response.headers().set("Content-Length", (Object)response.content().readableBytes());
    }

    private void populateCookies(FullHttpResponse response, OutgoingMessage outgoing) {
        if (outgoing.getCookies() != null) {
            for (Cookie cookie : outgoing.getCookies()) {
                response.headers().add("Set-Cookie", (Object)ServerCookieEncoder.encode((String)cookie.getName(), (String)cookie.getValue()));
            }
        }
    }

    private boolean write404NotFoundResponse(HttpRequestContext requestContext, ChannelHandlerContext ctx) {
        boolean keepAlive = requestContext.isKeepAlive();
        HttpVersion httpVersion = this.consumerContext.getHttpVersion();
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(httpVersion, HttpResponseStatus.NOT_FOUND);
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        if (!keepAlive) {
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            response.headers().set("Connection", (Object)"keep-alive");
            ctx.write((Object)response);
        }
        return keepAlive;
    }

    private OutgoingMessage getMatchResource(HttpRequestContext requestContext) {
        for (Map.Entry<IncomingMessage, OutgoingMessage> entry : this.consumerContext.getInOutCorrelation().entrySet()) {
            if (!entry.getKey().isMatch(requestContext)) continue;
            return entry.getValue();
        }
        return null;
    }
}

