/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.consumer;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import org.apache.log4j.Logger;
import org.apache.synapse.commons.emulator.http.consumer.HttpRequestContext;
import org.apache.synapse.commons.emulator.http.consumer.HttpRequestInformationProcessor;
import org.apache.synapse.commons.emulator.http.consumer.HttpResponseProcessor;
import org.apache.synapse.commons.emulator.http.dsl.HttpConsumerContext;

public class HttpResponseProcessHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = Logger.getLogger(HttpResponseProcessHandler.class);
    private HttpRequestContext httpRequestContext;
    private HttpRequestInformationProcessor httpRequestInformationProcessor;
    private HttpResponseProcessor httpResponseProcessor;
    private HttpConsumerContext consumerContext;

    public HttpResponseProcessHandler(HttpConsumerContext consumerContext) {
        this.consumerContext = consumerContext;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpRequest) {
            this.readingDelay(this.consumerContext.getReadingDelay());
            this.httpRequestContext = new HttpRequestContext();
            this.httpRequestInformationProcessor = new HttpRequestInformationProcessor();
            this.httpResponseProcessor = new HttpResponseProcessor(this.consumerContext);
            HttpRequest httpRequest = (HttpRequest)msg;
            if (HttpHeaders.is100ContinueExpected((HttpMessage)httpRequest)) {
                HttpResponseProcessHandler.send100Continue(ctx);
            }
            this.httpRequestInformationProcessor.process(httpRequest, this.httpRequestContext);
        } else {
            HttpContent httpContent;
            ByteBuf content;
            if (msg instanceof HttpContent && (content = (httpContent = (HttpContent)msg).content()).isReadable()) {
                this.httpRequestInformationProcessor.appendDecoderResult(this.httpRequestContext, (HttpObject)httpContent, content);
            }
            if (msg instanceof LastHttpContent) {
                ctx.fireChannelReadComplete();
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        if (this.httpResponseProcessor != null) {
            this.waitingDelay(this.consumerContext.getWritingDelay());
            this.httpResponseProcessor.process(this.httpRequestContext, ctx);
        }
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error((Object)"Exception occurred while processing the response", cause);
        ctx.close();
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.write((Object)response);
    }

    private void readingDelay(int delay) {
        try {
            if (delay > 0) {
                Thread.sleep(delay);
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"Exception occurred while processing the reading delay", (Throwable)e);
        }
    }

    private void waitingDelay(int delay) {
        try {
            if (delay > 0) {
                Thread.sleep(delay);
            }
        }
        catch (InterruptedException e) {
            log.error((Object)"Exception occurred while processing the waiting delay", (Throwable)e);
        }
    }
}

