/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.consumer;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.synapse.commons.emulator.RequestProcessor;

public class HttpRequestContext {
    private Map<String, List<String>> headerParameters;
    private Map<String, List<String>> queryParameters;
    private StringBuilder requestBody;
    private String uri;
    private HttpMethod httpMethod;
    private HttpVersion httpVersion;
    private boolean isKeepAlive;

    void addHeaderParameter(String key, String value) {
        List<String> headerValues;
        if (this.headerParameters == null) {
            this.headerParameters = new HashMap<String, List<String>>();
        }
        if ((headerValues = this.headerParameters.get(key)) == null) {
            headerValues = new ArrayList<String>();
        }
        headerValues.add(value);
        this.headerParameters.put(key, headerValues);
    }

    public Map<String, List<String>> getQueryParameters() {
        return this.queryParameters;
    }

    void setQueryParameters(Map<String, List<String>> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public Map<String, List<String>> getHeaderParameters() {
        return this.headerParameters;
    }

    void appendResponseContent(Object content) {
        if (this.requestBody == null) {
            this.requestBody = new StringBuilder();
        }
        this.requestBody.append(content);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    void setHttpVersion(HttpVersion httpVersion) {
        this.httpVersion = httpVersion;
    }

    boolean isKeepAlive() {
        return this.isKeepAlive;
    }

    void setKeepAlive(boolean isKeepAlive) {
        this.isKeepAlive = isKeepAlive;
    }

    public String getRequestBody() {
        if (this.requestBody == null) {
            return null;
        }
        return RequestProcessor.trimStrings(this.requestBody.toString());
    }
}

