/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http.consumer;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import org.apache.synapse.commons.emulator.core.EmulatorType;
import org.apache.synapse.commons.emulator.http.ChannelPipelineInitializer;
import org.apache.synapse.commons.emulator.http.dsl.HttpConsumerContext;

public class HttpEmulatorConsumerInitializer {
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private HttpConsumerContext consumerContext;

    public HttpEmulatorConsumerInitializer(HttpConsumerContext consumerContext) {
        this.consumerContext = consumerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup(this.getCPUCoreSize());
        this.workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ChannelPipelineInitializer channelPipelineInitializer = new ChannelPipelineInitializer(null, EmulatorType.HTTP_CONSUMER);
            channelPipelineInitializer.setConsumerContext(this.consumerContext);
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)channelPipelineInitializer);
            ChannelFuture f = serverBootstrap.bind(this.consumerContext.getHost(), this.consumerContext.getPort().intValue()).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            this.bossGroup.shutdownGracefully();
            this.workerGroup.shutdownGracefully();
        }
    }

    public void shutdown() {
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    private int getCPUCoreSize() {
        return Runtime.getRuntime().availableProcessors();
    }
}

