/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslContext;
import org.apache.synapse.commons.emulator.core.EmulatorType;
import org.apache.synapse.commons.emulator.http.dsl.HttpConsumerContext;
import org.apache.synapse.commons.emulator.http.dsl.dto.producer.OutgoingMessage;
import org.apache.synapse.commons.emulator.http.producer.HttpResponseProcessHandler;

public class ChannelPipelineInitializer
extends ChannelInitializer<SocketChannel> {
    private SslContext sslCtx;
    private HttpConsumerContext consumerContext;
    private OutgoingMessage producerOutgoingMessage;
    private EmulatorType emulatorType;

    public ChannelPipelineInitializer(SslContext sslCtx, EmulatorType emulatorType) {
        this.sslCtx = sslCtx;
        this.emulatorType = emulatorType;
    }

    public void initChannel(SocketChannel ch) {
        if (EmulatorType.HTTP_CONSUMER.equals((Object)this.emulatorType)) {
            this.initializeHttpConsumerChannel(ch);
        } else if (EmulatorType.HTTP_PRODUCER.equals((Object)this.emulatorType)) {
            this.initializeHttpProducerChannel(ch);
        }
    }

    private void initializeHttpConsumerChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslCtx != null) {
            pipeline.addLast("sslHandler", (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        if (this.consumerContext.getLogicHandler() != null) {
            pipeline.addLast("logicHandler", (ChannelHandler)this.consumerContext.getLogicHandler());
        }
        pipeline.addLast("httpResponseHandler", (ChannelHandler)new org.apache.synapse.commons.emulator.http.consumer.HttpResponseProcessHandler(this.consumerContext));
    }

    private void initializeHttpProducerChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslCtx != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpResponseProcessHandler(this.producerOutgoingMessage)});
    }

    public void setProducerOutgoingMessage(OutgoingMessage producerOutgoingMessage) {
        this.producerOutgoingMessage = producerOutgoingMessage;
    }

    public void setConsumerContext(HttpConsumerContext consumerContext) {
        this.consumerContext = consumerContext;
    }
}

