/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class TreeMapTypeAdapterFactory
implements TypeAdapterFactory {
    public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (Map.class.isAssignableFrom(type.getRawType())) {
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return this.createCustomTypeAdapter(delegate);
        }
        return null;
    }

    private <T> TypeAdapter<T> createCustomTypeAdapter(final TypeAdapter<T> delegate) {
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                Map map = (Map)value;
                delegate.write(out, new TreeMap(map));
            }

            public T read(JsonReader in) throws IOException {
                return delegate.read(in);
            }
        };
    }
}

