/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.emulator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.apache.synapse.commons.emulator.TreeMapTypeAdapterFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class RequestProcessor {
    private static Logger log = Logger.getLogger((String)RequestProcessor.class.getName());

    RequestProcessor() {
    }

    public static String trimStrings(String inputString) {
        String trimedString = inputString.trim();
        if (trimedString.startsWith("<![CDATA[")) {
            int index = (trimedString = trimedString.substring(9)).indexOf("]]>");
            if (index == -1) {
                throw new IllegalStateException("argument starts with <![CDATA[ but cannot find pairing ]]>");
            }
            trimedString = trimedString.substring(0, index);
        }
        trimedString = RequestProcessor.convertStringToRelatedDocumentType(trimedString);
        return trimedString.replaceAll("\\s", "");
    }

    private static String convertStringToRelatedDocumentType(String domString) {
        String processedString;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new DefaultHandler());
            Document xmlDOM = builder.parse(new InputSource(new StringReader(domString)));
            processedString = RequestProcessor.nodeToString(xmlDOM);
            processedString = processedString.replaceAll("xmlns=\"\"", "");
        }
        catch (Exception e) {
            processedString = RequestProcessor.convertAsJSONString(domString);
        }
        return processedString;
    }

    private static String nodeToString(Node node) {
        StringWriter stringWriter = new StringWriter();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
        }
        catch (Exception e) {
            log.error((Object)"nodeToString Transformer Exception", (Throwable)e);
        }
        return stringWriter.toString();
    }

    private static String convertAsJSONString(String inputString) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapterFactory((TypeAdapterFactory)new TreeMapTypeAdapterFactory()).create();
            Map root = (Map)gson.fromJson(inputString, Map.class);
            return gson.toJson((Object)root);
        }
        catch (Exception e) {
            return inputString;
        }
    }
}

