/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.datasource;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.SynapseCommonsException;
import org.apache.synapse.commons.datasource.DBPoolView;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.commons.jmx.MBeanRepository;

public class DatasourceMBeanRepository
implements MBeanRepository {
    private static final Log log = LogFactory.getLog(DatasourceMBeanRepository.class);
    private final Map<String, DBPoolView> dataSourcesMBeans = new HashMap<String, DBPoolView>();
    private static final DatasourceMBeanRepository DATASOURCE_MBEAN_REPOSITORY = new DatasourceMBeanRepository();
    private static final String MBEAN_CATEGORY_DATABASE_CONNECTION_POOL = "DatabaseConnectionPool";

    private DatasourceMBeanRepository() {
    }

    public static DatasourceMBeanRepository getInstance() {
        return DATASOURCE_MBEAN_REPOSITORY;
    }

    @Override
    public void addMBean(String name, Object mBean) {
        if (name == null || "".equals(name)) {
            throw new SynapseCommonsException("DataSource MBean name cannot be found.", log);
        }
        if (mBean == null) {
            throw new SynapseCommonsException("DataSource MBean  cannot be found.", log);
        }
        if (!(mBean instanceof DBPoolView)) {
            throw new SynapseCommonsException("Given MBean instance is not matchedwith the expected MBean - 'DBPoolView'", log);
        }
        this.dataSourcesMBeans.put(name, (DBPoolView)mBean);
        MBeanRegistrar.getInstance().registerMBean(mBean, MBEAN_CATEGORY_DATABASE_CONNECTION_POOL, name);
    }

    @Override
    public Object getMBean(String name) {
        if (name == null || "".equals(name)) {
            throw new SynapseCommonsException("DataSource MBean name cannot be found.", log);
        }
        return this.dataSourcesMBeans.get(name);
    }

    @Override
    public void removeMBean(String name) {
        this.dataSourcesMBeans.remove(name);
        this.unregisterMBean(name);
    }

    private void unregisterMBean(String name) {
        MBeanRegistrar.getInstance().unRegisterMBean(MBEAN_CATEGORY_DATABASE_CONNECTION_POOL, name);
    }

    @Override
    public void clear() {
        if (!this.dataSourcesMBeans.isEmpty()) {
            log.info((Object)"UnRegistering DBPool MBeans");
            for (DBPoolView dbPoolView : this.dataSourcesMBeans.values()) {
                if (dbPoolView == null) continue;
                this.unregisterMBean(dbPoolView.getName());
            }
            this.dataSourcesMBeans.clear();
        }
    }
}

