/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.crypto;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.crypto.EncodeDecodeTypes;

public class Util {
    private static Log log = LogFactory.getLog(Util.class);

    public static boolean validatePasswords(String identityStorePass, String identityKeyPass) {
        boolean isValid = false;
        if (identityStorePass != null && !"".equals(identityStorePass) && identityKeyPass != null && !"".equals(identityKeyPass)) {
            isValid = true;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Identity store password and/or identity store private key password cannot be found.");
        }
        return isValid;
    }

    public static EncodeDecodeTypes getEncodeDecodeType(String value, EncodeDecodeTypes defaultValue) {
        if (value != null && !value.isEmpty() && value.equals((Object)EncodeDecodeTypes.BASE64)) {
            return EncodeDecodeTypes.BASE64;
        }
        if (value != null && !value.isEmpty() && value.equals((Object)EncodeDecodeTypes.BIGINTEGER16)) {
            return EncodeDecodeTypes.BIGINTEGER16;
        }
        if (value != null && !value.isEmpty() && value.equals((Object)EncodeDecodeTypes.HEX)) {
            return EncodeDecodeTypes.HEX;
        }
        return defaultValue;
    }

    public static byte[] append(byte[] value, byte[] toAppend) {
        int i;
        byte[] response = new byte[value.length + toAppend.length];
        for (i = 0; i < value.length; ++i) {
            response[i] = value[i];
        }
        for (i = 0; i < toAppend.length; ++i) {
            response[i + value.length] = toAppend[i];
        }
        return response;
    }
}

