/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.builders;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.transport.http.util.URIEncoderDecoder;
import org.apache.axis2.util.MultipleEntryHashMap;

public class XFormURLEncodedBuilder
implements Builder {
    private static final QName XFORM_FIRST_ELEMENT = new QName("xformValues");

    public OMElement processDocument(InputStream inputStream, String s, MessageContext messageContext) throws AxisFault {
        SOAPEnvelope soapEnv = (SOAPEnvelope)this.processDocumentWrapper(inputStream, s, messageContext);
        SOAPBody body = soapEnv.getBody();
        String httpMethod = (String)messageContext.getProperty("HTTP_METHOD_OBJECT");
        if (body.getFirstElement() == null && "POST".equals(httpMethod) && messageContext.getProperty("requestParameterMap") != null) {
            MultipleEntryHashMap map = (MultipleEntryHashMap)messageContext.getProperty("requestParameterMap");
            SOAPFactory soapFactory = this.getSOAPFactory(messageContext);
            OMElement bodyFirstChild = soapFactory.createOMElement(XFORM_FIRST_ELEMENT, (OMContainer)body);
            XFormURLEncodedBuilder.createSOAPMessageWithoutSchema(soapFactory, bodyFirstChild, map);
        } else if (body.getFirstElement() != null && "mediate".equals(body.getFirstElement().getLocalName())) {
            body.getFirstElement().setLocalName(XFORM_FIRST_ELEMENT.getLocalPart());
        }
        return soapEnv;
    }

    private OMElement processDocumentWrapper(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        SOAPFactory soapFactory;
        AxisEndpoint axisEndpoint;
        MultipleEntryHashMap parameterMap = new MultipleEntryHashMap();
        AxisBindingOperation axisBindingOperation = (AxisBindingOperation)messageContext.getProperty("AxisBindingOperation");
        String queryParameterSeparator = null;
        String templatedPath = null;
        if (axisBindingOperation != null) {
            queryParameterSeparator = (String)axisBindingOperation.getProperty("whttp:queryParameterSeparator");
            templatedPath = (String)axisBindingOperation.getProperty("whttp:location");
        }
        if (queryParameterSeparator == null) {
            queryParameterSeparator = "&";
        }
        if ((axisEndpoint = (AxisEndpoint)messageContext.getProperty("endpoint")) != null) {
            AxisBinding axisBinding = axisEndpoint.getBinding();
            String soapVersion = (String)axisBinding.getProperty("wsoap:version");
            soapFactory = this.getSOAPFactory(soapVersion);
        } else {
            soapFactory = this.getSOAPFactory("http://www.w3.org/2003/05/soap-envelope");
        }
        EndpointReference endpointReference = messageContext.getTo();
        if (endpointReference == null) {
            throw new AxisFault("Cannot create DocumentElement without destination EPR");
        }
        String requestURL = endpointReference.getAddress();
        try {
            requestURL = this.extractParametersUsingHttpLocation(templatedPath, parameterMap, requestURL, queryParameterSeparator);
        }
        catch (UnsupportedEncodingException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        String query = requestURL;
        int index = requestURL.indexOf("?");
        if (index > -1) {
            query = requestURL.substring(index + 1);
        }
        this.extractParametersFromRequest(parameterMap, query, queryParameterSeparator, (String)messageContext.getProperty("CHARACTER_SET_ENCODING"), inputStream);
        messageContext.setProperty("requestParameterMap", (Object)parameterMap);
        return BuilderUtil.buildsoapMessage((MessageContext)messageContext, (MultipleEntryHashMap)parameterMap, (SOAPFactory)soapFactory);
    }

    private static void createSOAPMessageWithoutSchema(SOAPFactory soapFactory, OMElement bodyFirstChild, MultipleEntryHashMap requestParameterMap) {
        if (requestParameterMap != null) {
            for (Object o : requestParameterMap.keySet()) {
                Object value;
                String key = (String)o;
                while ((value = requestParameterMap.get((Object)key)) != null) {
                    XFormURLEncodedBuilder.addRequestParameter(soapFactory, bodyFirstChild, null, key, value);
                }
            }
        }
    }

    private static void addRequestParameter(SOAPFactory soapFactory, OMElement bodyFirstChild, OMNamespace ns, String key, Object parameter) {
        if (parameter instanceof DataHandler) {
            DataHandler dataHandler = (DataHandler)parameter;
            OMText dataText = bodyFirstChild.getOMFactory().createOMText((Object)dataHandler, true);
            soapFactory.createOMElement(key, ns, (OMContainer)bodyFirstChild).addChild((OMNode)dataText);
        } else {
            String textValue = parameter.toString();
            soapFactory.createOMElement(key, ns, (OMContainer)bodyFirstChild).setText(textValue);
        }
    }

    private void extractParametersFromRequest(MultipleEntryHashMap parameterMap, String query, String queryParamSeparator, final String charsetEncoding, final InputStream inputStream) throws AxisFault {
        if (query != null && !"".equals(query)) {
            String[] parts;
            for (String part : parts = query.split(queryParamSeparator)) {
                int separator = part.indexOf("=");
                if (separator <= 0) continue;
                String value = part.substring(separator + 1);
                try {
                    value = URIEncoderDecoder.decode((String)value, (String)charsetEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw AxisFault.makeFault((Throwable)e);
                }
                parameterMap.put((Object)this.replaceInvalidCharacters(part.substring(0, separator)), (Object)value);
            }
        }
        if (inputStream != null) {
            try {
                String line;
                InputStreamReader inputStreamReader;
                try {
                    inputStreamReader = (InputStreamReader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws UnsupportedEncodingException {
                            return new InputStreamReader(inputStream, charsetEncoding);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (UnsupportedEncodingException)e.getException();
                }
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((line = bufferedReader.readLine()) != null) {
                    String[] parts;
                    for (String part : parts = line.split("&")) {
                        int separator = part.indexOf("=");
                        String value = part.substring(separator + 1);
                        parameterMap.put((Object)this.replaceInvalidCharacters(part.substring(0, separator)), (Object)URIEncoderDecoder.decode((String)value, (String)charsetEncoding));
                    }
                }
            }
            catch (IOException e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
    }

    private String replaceInvalidCharacters(String keyString) {
        if (Pattern.compile("^[0-9]").matcher(keyString).find()) {
            return "_JsonReader_PD_" + keyString;
        }
        if (keyString.startsWith("$")) {
            return "_JsonReader_PS_" + keyString.substring(1);
        }
        return keyString;
    }

    private SOAPFactory getSOAPFactory(MessageContext messageContext) throws AxisFault {
        SOAPFactory soapFactory;
        AxisEndpoint axisEndpoint = (AxisEndpoint)messageContext.getProperty("endpoint");
        if (axisEndpoint != null) {
            AxisBinding axisBinding = axisEndpoint.getBinding();
            String soapVersion = (String)axisBinding.getProperty("wsoap:version");
            soapFactory = this.getSOAPFactory(soapVersion);
        } else {
            soapFactory = this.getSOAPFactory("http://www.w3.org/2003/05/soap-envelope");
        }
        return soapFactory;
    }

    private SOAPFactory getSOAPFactory(String nsURI) throws AxisFault {
        if (nsURI == null) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://www.w3.org/2003/05/soap-envelope".equals(nsURI)) {
            return OMAbstractFactory.getSOAP12Factory();
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(nsURI)) {
            return OMAbstractFactory.getSOAP11Factory();
        }
        throw new AxisFault(Messages.getMessage((String)"invalidSOAPversion"));
    }

    private String extractParametersUsingHttpLocation(String templatedPath, MultipleEntryHashMap parameterMap, String requestURL, String queryParameterSeparator) throws AxisFault, UnsupportedEncodingException {
        if (templatedPath != null && !"".equals(templatedPath) && templatedPath.contains("{")) {
            StringBuilder pathTemplate = new StringBuilder(templatedPath);
            int startIndex = 0;
            int templateStartIndex = 0;
            int templateEndIndex = 0;
            int indexOfNextConstant = 0;
            StringBuilder requestURIBuffer = new StringBuilder(requestURL);
            while (startIndex < requestURIBuffer.length()) {
                if ((templateStartIndex = pathTemplate.indexOf("{", templateStartIndex)) <= 0) continue;
                String constantPart = pathTemplate.substring(templateEndIndex + 1, templateStartIndex);
                constantPart = constantPart.replaceAll("\\{\\{", "{");
                constantPart = constantPart.replaceAll("}}", "}");
                templateEndIndex = pathTemplate.indexOf("}", templateStartIndex);
                if (pathTemplate.length() - 1 > templateEndIndex && pathTemplate.charAt(templateEndIndex + 1) == '}') {
                    templateEndIndex = pathTemplate.indexOf("}", templateEndIndex + 2);
                }
                String parameterName = pathTemplate.substring(templateStartIndex + 1, templateEndIndex);
                templateStartIndex = pathTemplate.indexOf("{", templateEndIndex);
                if (pathTemplate.charAt(templateStartIndex + 1) == '{') {
                    templateStartIndex = pathTemplate.indexOf("{", templateStartIndex + 2);
                }
                int endIndexOfConstant = requestURIBuffer.indexOf(constantPart, indexOfNextConstant) + constantPart.length();
                if (templateStartIndex == -1) {
                    if (templateEndIndex == pathTemplate.length() - 1) {
                        indexOfNextConstant = requestURIBuffer.indexOf("?", endIndexOfConstant);
                        if (indexOfNextConstant == -1) {
                            indexOfNextConstant = requestURIBuffer.indexOf(queryParameterSeparator, endIndexOfConstant);
                        }
                        if (indexOfNextConstant > 0) {
                            this.addParameterToMap(parameterMap, parameterName, requestURIBuffer.substring(endIndexOfConstant, indexOfNextConstant));
                            return requestURL.substring(indexOfNextConstant);
                        }
                        this.addParameterToMap(parameterMap, parameterName, requestURIBuffer.substring(endIndexOfConstant));
                        return "";
                    }
                    constantPart = pathTemplate.substring(templateEndIndex + 1, pathTemplate.length());
                    constantPart = constantPart.replaceAll("\\{\\{", "{");
                    constantPart = constantPart.replaceAll("}}", "}");
                    indexOfNextConstant = requestURIBuffer.indexOf(constantPart, endIndexOfConstant);
                    this.addParameterToMap(parameterMap, parameterName, requestURIBuffer.substring(endIndexOfConstant, indexOfNextConstant));
                    if (requestURIBuffer.length() > indexOfNextConstant + 1) {
                        return requestURIBuffer.substring(indexOfNextConstant + 1);
                    }
                    return "";
                }
                constantPart = pathTemplate.substring(templateEndIndex + 1, templateStartIndex);
                constantPart = constantPart.replaceAll("\\{\\{", "{");
                constantPart = constantPart.replaceAll("}}", "}");
                indexOfNextConstant = requestURIBuffer.indexOf(constantPart, endIndexOfConstant);
                this.addParameterToMap(parameterMap, parameterName, requestURIBuffer.substring(endIndexOfConstant, indexOfNextConstant));
                startIndex = indexOfNextConstant;
            }
        }
        return requestURL;
    }

    private void addParameterToMap(MultipleEntryHashMap parameterMap, String paramName, String paramValue) throws UnsupportedEncodingException, AxisFault {
        try {
            paramValue = URIEncoderDecoder.decode((String)paramValue);
        }
        catch (UnsupportedEncodingException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        if (paramName.startsWith("!")) {
            parameterMap.put((Object)paramName.substring(1), (Object)paramValue);
        } else {
            parameterMap.put((Object)paramName, (Object)paramValue);
        }
    }
}

