/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TokenValidator;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.rahas.impl.TokenIssuerUtil;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.saml.SAML2Util;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAMLTokenValidator
implements TokenValidator {
    private static final Log log = LogFactory.getLog(SAMLTokenValidator.class);
    private String configFile;
    private OMElement configElement;
    private String configParamName;

    @Override
    public SOAPEnvelope validate(RahasData data) throws TrustException {
        OMElement rstrElem;
        MessageContext inMsgCtx = data.getInMessageContext();
        TokenStorage tkStorage = TrustUtil.getTokenStore(inMsgCtx);
        SOAPEnvelope env = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
        int wstVersion = data.getVersion();
        if (1 == wstVersion) {
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
        } else {
            OMElement rstrcElem = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, rstrcElem);
        }
        TrustUtil.createTokenTypeElement(wstVersion, rstrElem).setText(TrustUtil.getWSTNamespace(wstVersion) + "/RSTR/Status");
        OMElement statusElement = SAMLTokenValidator.createMessageElement(wstVersion, rstrElem, "Status");
        Token tk = tkStorage.getToken(data.getTokenId());
        SAMLTokenIssuerConfig config = this.getConfig(inMsgCtx);
        Crypto crypto = this.getCrypto(inMsgCtx, config);
        PublicKey issuerPBKey = this.getIssuerPublicKey(config, crypto);
        boolean valid = this.isValid(tk, issuerPBKey, crypto);
        String validityCode = valid ? "/status/valid" : "/status/invalid";
        SAMLTokenValidator.createMessageElement(wstVersion, statusElement, "Code").setText(TrustUtil.getWSTNamespace(wstVersion) + validityCode);
        return env;
    }

    private boolean isValid(Token token, PublicKey issuerPBKey, Crypto crypto) {
        OMElement assertionOMElement = token.getToken();
        SAMLAssertion samlAssertion = null;
        if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(assertionOMElement.getQName().getNamespaceURI())) {
            Assertion assertion = null;
            try {
                assertion = this.buildAssertion(assertionOMElement.toString());
                if (assertion.getSignature() != null) {
                    SAML2Util.validateSignature((Assertion)assertion, (Crypto)crypto);
                }
            }
            catch (WSSecurityException e) {
                log.error((Object)"Could not verify signature", (Throwable)e);
                return false;
            }
            return true;
        }
        try {
            samlAssertion = new SAMLAssertion((Element)assertionOMElement);
            log.info((Object)"Verifying token validity...");
            samlAssertion.verify((Key)issuerPBKey);
        }
        catch (SAMLException e) {
            log.error((Object)"Could not verify signature", (Throwable)e);
            return false;
        }
        return true;
    }

    private SAMLTokenIssuerConfig getConfig(MessageContext inMsgCtx) {
        SAMLTokenIssuerConfig config = null;
        try {
            if (this.configElement != null) {
                config = new SAMLTokenIssuerConfig(this.configElement.getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
            }
            if (config == null && this.configFile != null) {
                config = new SAMLTokenIssuerConfig(this.configFile);
            }
            if (config == null && this.configParamName != null) {
                Parameter param = inMsgCtx.getParameter(this.configParamName);
                if (param != null && param.getParameterElement() != null) {
                    config = new SAMLTokenIssuerConfig(param.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
                } else {
                    throw new TrustException("expectedParameterMissing", new String[]{this.configParamName});
                }
            }
            if (config == null) {
                throw new TrustException("configurationIsNull");
            }
            if (config.isTokenStoreDisabled()) {
                throw new TrustException("errorTokenStoreDisabled");
            }
            if (TokenIssuerUtil.isPersisterConfigured(config)) {
                TokenIssuerUtil.manageTokenPersistenceSettings(config, inMsgCtx);
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not build crypto object", (Throwable)e);
        }
        return config;
    }

    private Crypto getCrypto(MessageContext inMsgCtx, SAMLTokenIssuerConfig config) {
        if (config.cryptoElement != null) {
            return CryptoFactory.getInstance((Properties)TrustUtil.toProperties(config.cryptoElement), (ClassLoader)inMsgCtx.getAxisService().getClassLoader());
        }
        return CryptoFactory.getInstance((String)config.cryptoPropertiesFile, (ClassLoader)inMsgCtx.getAxisService().getClassLoader());
    }

    private PublicKey getIssuerPublicKey(SAMLTokenIssuerConfig config, Crypto crypto) {
        PublicKey issuerPBKey = null;
        try {
            issuerPBKey = crypto.getCertificates(config.issuerKeyAlias)[0].getPublicKey();
        }
        catch (WSSecurityException e) {
            log.error((Object)"Error occurred while retrieving issuer public key.", (Throwable)e);
        }
        return issuerPBKey;
    }

    public Assertion buildAssertion(String elem) throws WSSecurityException {
        Assertion samlAssertion;
        try {
            DocumentBuilderFactory documentBuilderFactory = TrustUtil.getSecuredDocumentBuilderFactory();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(elem.trim().getBytes()));
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            samlAssertion = (Assertion)unmarshaller.unmarshall(element);
        }
        catch (UnmarshallingException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, (Throwable)e);
        }
        catch (IOException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, (Throwable)e);
        }
        catch (SAXException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new WSSecurityException(0, "Failure in unmarshelling the assertion", null, (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"SAML2 Token was validated successfully.");
        }
        return samlAssertion;
    }

    private static OMElement createMessageElement(int version, OMElement parent, String elementName) throws TrustException {
        return SAMLTokenValidator.createOMElement(parent, TrustUtil.getWSTNamespace(version), elementName, "wst");
    }

    private static OMElement createOMElement(OMElement parent, String ns, String ln, String prefix) {
        return parent.getOMFactory().createOMElement(new QName(ns, ln, prefix), (OMContainer)parent);
    }

    @Override
    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }

    @Override
    public void setConfigurationElement(OMElement configElement) {
        this.configElement = configElement;
    }

    static {
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            log.error((Object)"SAMLTokenValidatorBootstrapError", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

