/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.dom.jaxp.DocumentBuilderFactoryImpl;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenRenewer;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.rahas.impl.TokenIssuerUtil;
import org.apache.rahas.impl.util.SAMLUtils;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLTokenRenewer
implements TokenRenewer {
    private String configParamName;
    private OMElement configElement;
    private String configFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SOAPEnvelope renew(RahasData data) throws TrustException {
        MessageContext inMsgCtx = data.getInMessageContext();
        TokenStorage tkStorage = TrustUtil.getTokenStore(inMsgCtx);
        SAMLTokenIssuerConfig config = this.setConfig(inMsgCtx);
        try {
            if (!TrustUtil.isDoomParserPoolUsed()) {
                DocumentBuilderFactoryImpl.setDOOMRequired((boolean)true);
            }
            SOAPEnvelope env = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
            OMElement rstrElem = this.buildResponse(inMsgCtx, data, env, "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            int wstVersion = data.getVersion();
            Date creationTime = new Date();
            Date expirationTime = new Date();
            expirationTime.setTime(creationTime.getTime() + config.ttl);
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            TrustUtil.createLifetimeElement(wstVersion, rstrElem, zulu.format(creationTime), zulu.format(expirationTime));
            Token tk = tkStorage.getToken(data.getTokenId());
            OMElement assertionOMElement = tk.getToken();
            SAMLAssertion samlAssertion = null;
            try {
                samlAssertion = new SAMLAssertion((Element)assertionOMElement);
                samlAssertion.unsign();
                samlAssertion.setNotBefore(creationTime);
                samlAssertion.setNotOnOrAfter(expirationTime);
                Crypto crypto = this.getCrypto(inMsgCtx, config);
                samlAssertion = this.signAssertion(crypto, samlAssertion, config);
                OMElement reqSecTokenElem = TrustUtil.createRequestedSecurityTokenElement(wstVersion, rstrElem);
                Node tempNode = samlAssertion.toDOM();
                reqSecTokenElem.addChild((OMNode)((Element)rstrElem).getOwnerDocument().importNode(tempNode, true));
            }
            catch (SAMLException e) {
                throw new TrustException("Cannot Create SAML Assertion", e);
            }
            catch (Exception e) {
                throw new TrustException("Cannot Create SAML Assertion", e);
            }
            SOAPEnvelope sOAPEnvelope = env;
            return sOAPEnvelope;
        }
        finally {
            if (!TrustUtil.isDoomParserPoolUsed()) {
                DocumentBuilderFactoryImpl.setDOOMRequired((boolean)false);
            }
        }
    }

    protected SAMLAssertion signAssertion(Crypto crypto, SAMLAssertion samlAssertion, SAMLTokenIssuerConfig config) throws Exception {
        X509Certificate[] issuerCerts = crypto.getCertificates(config.issuerKeyAlias);
        String sigAlgo = SAMLUtils.getSignatureAlgorithm(config, issuerCerts);
        PrivateKey issuerPK = crypto.getPrivateKey(config.issuerKeyAlias, config.issuerKeyPassword);
        samlAssertion.sign(sigAlgo, (Key)issuerPK, Arrays.asList(issuerCerts));
        return samlAssertion;
    }

    protected Crypto getCrypto(MessageContext inMsgCtx, SAMLTokenIssuerConfig config) {
        Crypto crypto = config.cryptoElement != null ? CryptoFactory.getInstance((Properties)TrustUtil.toProperties(config.cryptoElement), (ClassLoader)inMsgCtx.getAxisService().getClassLoader()) : CryptoFactory.getInstance((String)config.cryptoPropertiesFile, (ClassLoader)inMsgCtx.getAxisService().getClassLoader());
        return crypto;
    }

    protected SAMLTokenIssuerConfig setConfig(MessageContext inMsgCtx) throws TrustException {
        SAMLTokenIssuerConfig config = null;
        if (this.configElement != null) {
            config = new SAMLTokenIssuerConfig(this.configElement.getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
        }
        if (config == null && this.configFile != null) {
            config = new SAMLTokenIssuerConfig(this.configFile);
        }
        if (config == null && this.configParamName != null) {
            Parameter param = inMsgCtx.getParameter(this.configParamName);
            if (param != null && param.getParameterElement() != null) {
                config = new SAMLTokenIssuerConfig(param.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG));
            } else {
                throw new TrustException("expectedParameterMissing", new String[]{this.configParamName});
            }
        }
        if (config == null) {
            throw new TrustException("configurationIsNull");
        }
        if (config.isTokenStoreDisabled()) {
            throw new TrustException("errorTokenStoreDisabled");
        }
        if (TokenIssuerUtil.isPersisterConfigured(config)) {
            TokenIssuerUtil.manageTokenPersistenceSettings(config, inMsgCtx);
        }
        return config;
    }

    protected OMElement buildResponse(MessageContext inMsgCtx, RahasData data, SOAPEnvelope env, String tokenType) throws TrustException {
        OMElement rstrElem;
        int wstVersion = data.getVersion();
        if (1 == wstVersion) {
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)env.getBody());
        } else {
            OMElement rstrcElem = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)env.getBody());
            rstrElem = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, rstrcElem);
        }
        TrustUtil.createTokenTypeElement(wstVersion, rstrElem).setText(tokenType);
        return rstrElem;
    }

    @Override
    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    @Override
    public void setConfigurationElement(OMElement configElement) {
        this.configElement = configElement;
    }

    @Override
    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }
}

