/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.client;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.util.Base64;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.rahas.Token;
import org.apache.rahas.TokenStorage;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.Binding;
import org.apache.ws.secpolicy.model.Trust10;
import org.apache.ws.secpolicy.model.Trust13;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.P_SHA1;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Element;

public class STSClient {
    private static final String RAMPART_POLICY = "rampartPolicy";
    private static final Log log = LogFactory.getLog(STSClient.class);
    private String action;
    private OMElement rstTemplate;
    private int version = 1;
    private Options options;
    private Trust10 trust10;
    private Trust13 trust13;
    private AlgorithmSuite algorithmSuite;
    private ArrayList parameters = new ArrayList();
    private byte[] requestorEntropy;
    private String addressingNs = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private int keySize;
    private String soapVersion = "http://www.w3.org/2003/05/soap-envelope";
    private int ttl = 300;
    private Crypto crypto;
    private CallbackHandler cbHandler;
    private ConfigurationContext configCtx;

    public STSClient(ConfigurationContext configCtx) throws TrustException {
        if (configCtx == null) {
            throw new TrustException("stsClientCfgCtxNull");
        }
        this.configCtx = configCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token requestSecurityToken(Policy servicePolicy, String issuerAddress, Policy issuerPolicy, String appliesTo, Options options) throws TrustException {
        Token token;
        QName rstQn = new QName("requestSecurityToken");
        String requestType = TrustUtil.getWSTNamespaceForRSTRequestTye(this.version) + "/Issue";
        ServiceClient client = this.getServiceClient(rstQn, issuerAddress);
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter param = (Parameter)this.parameters.get(i);
            client.getAxisService().addParameter(param.getName(), param.getValue());
        }
        client.getServiceContext().setProperty(RAMPART_POLICY, (Object)issuerPolicy);
        client.getOptions().setSoapVersionURI(this.soapVersion);
        if (this.addressingNs != null) {
            client.getOptions().setProperty("WSAddressingVersion", (Object)this.addressingNs);
        }
        if (options != null) {
            Map properties = options.getProperties();
            if (properties != null) {
                for (Map.Entry entry : properties.entrySet()) {
                    client.getOptions().setProperty((String)entry.getKey(), entry.getValue());
                }
            }
            if (options.getSoapVersionURI() != null) {
                client.getOptions().setSoapVersionURI(options.getSoapVersionURI());
            }
        }
        client.engageModule("addressing");
        client.engageModule("rampart");
        this.processPolicy(issuerPolicy, servicePolicy);
        try {
            OMElement response = client.sendReceive(rstQn, this.createIssueRequest(requestType, appliesTo));
            token = this.processIssueResponse(this.version, response, issuerAddress);
        }
        catch (Throwable throwable) {
            try {
                client.cleanupTransport();
                throw throwable;
            }
            catch (AxisFault e) {
                log.error((Object)"errorInObtainingToken", (Throwable)e);
                throw new TrustException("errorInObtainingToken", new String[]{issuerAddress}, e);
            }
        }
        client.cleanupTransport();
        return token;
    }

    public Token requestSecurityToken(Policy servicePolicy, String issuerAddress, Policy issuerPolicy, String appliesTo) throws TrustException {
        return this.requestSecurityToken(servicePolicy, issuerAddress, issuerPolicy, appliesTo, null);
    }

    @Deprecated
    public boolean cancelToken(String issuerAddress, String tokenId, String action) throws TrustException {
        try {
            QName rstQn = new QName("cancelSecurityToken");
            ServiceClient client = this.getServiceClient(rstQn, issuerAddress);
            if (action != null) {
                client.getOptions().setAction(action);
            }
            return this.processCancelResponse(client.sendReceive(rstQn, this.createCancelRequest(tokenId)));
        }
        catch (AxisFault e) {
            log.error((Object)"errorInCancelingToken", (Throwable)e);
            throw new TrustException("errorInCancelingToken", e);
        }
    }

    public boolean cancelToken(String tokenId, String issuerAddress, Policy issuerPolicy) throws TrustException {
        try {
            QName rstQn = new QName("cancelSecurityToken");
            ServiceClient client = this.getServiceClient(rstQn, issuerAddress);
            client.getServiceContext().setProperty(RAMPART_POLICY, (Object)issuerPolicy);
            client.getOptions().setSoapVersionURI(this.soapVersion);
            if (this.addressingNs != null) {
                client.getOptions().setProperty("WSAddressingVersion", (Object)this.addressingNs);
            }
            client.engageModule("addressing");
            client.engageModule("rampart");
            this.processPolicy(issuerPolicy, null);
            return this.processCancelResponse(client.sendReceive(rstQn, this.createCancelRequest(tokenId)));
        }
        catch (AxisFault e) {
            log.error((Object)"errorInCancelingToken", (Throwable)e);
            throw new TrustException("errorInCancelingToken", e);
        }
    }

    public boolean validateToken(String tokenId, String issuerAddress, Policy issuerPolicy) throws TrustException {
        try {
            QName rstQn = new QName("requestSecurityToken");
            String requestType = TrustUtil.getWSTNamespaceForRSTRequestTye(this.version) + "/Validate";
            ServiceClient client = this.getServiceClient(rstQn, issuerAddress);
            client.getServiceContext().setProperty(RAMPART_POLICY, (Object)issuerPolicy);
            client.getOptions().setSoapVersionURI(this.soapVersion);
            if (this.addressingNs != null) {
                client.getOptions().setProperty("WSAddressingVersion", (Object)this.addressingNs);
            }
            client.engageModule("addressing");
            client.engageModule("rampart");
            this.processPolicy(issuerPolicy, null);
            OMElement response = client.sendReceive(rstQn, this.createValidateRequest(requestType, tokenId));
            return (TrustUtil.getWSTNamespace(this.version) + "/status/valid").equals(response.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "Status")).getFirstElement().getText());
        }
        catch (AxisFault e) {
            log.error((Object)"errorInValidatingToken", (Throwable)e);
            throw new TrustException("errorInValidatingToken", new String[]{issuerAddress}, e);
        }
    }

    public boolean renewToken(String tokenId, String issuerAddress, Policy issuerPolicy) throws TrustException {
        try {
            QName rstQn = new QName("requestSecurityToken");
            ServiceClient client = this.getServiceClient(rstQn, issuerAddress);
            client.getServiceContext().setProperty(RAMPART_POLICY, (Object)issuerPolicy);
            client.getOptions().setSoapVersionURI(this.soapVersion);
            if (this.addressingNs != null) {
                client.getOptions().setProperty("WSAddressingVersion", (Object)this.addressingNs);
            }
            client.engageModule("addressing");
            client.engageModule("rampart");
            this.processPolicy(issuerPolicy, null);
            String tokenType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
            OMElement response = client.sendReceive(rstQn, this.createRenewRequest(tokenType, tokenId));
            return true;
        }
        catch (AxisFault e) {
            log.error((Object)"errorInRenewingToken", (Throwable)e);
            throw new TrustException("errorInRenewingToken", new String[]{issuerAddress}, e);
        }
    }

    public boolean renewToken(String tokenId, String issuerAddress, Policy issuerPolicy, TokenStorage store) throws TrustException {
        try {
            QName rstQn = new QName("requestSecurityToken");
            ServiceClient client = this.getServiceClient(rstQn, issuerAddress);
            client.getServiceContext().setProperty(RAMPART_POLICY, (Object)issuerPolicy);
            client.getOptions().setSoapVersionURI(this.soapVersion);
            if (this.addressingNs != null) {
                client.getOptions().setProperty("WSAddressingVersion", (Object)this.addressingNs);
            }
            client.engageModule("addressing");
            client.engageModule("rampart");
            this.processPolicy(issuerPolicy, null);
            String tokenType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
            OMElement response = client.sendReceive(rstQn, this.createRenewRequest(tokenType, tokenId));
            store.update(this.processRenewResponse(this.version, response, store, tokenId));
            return true;
        }
        catch (AxisFault e) {
            log.error((Object)"errorInRenewingToken", (Throwable)e);
            throw new TrustException("errorInRenewingToken", new String[]{issuerAddress}, e);
        }
    }

    public boolean renewToken(String tokenId, String tokenType, String issuerAddress, Policy issuerPolicy, TokenStorage store) throws TrustException {
        try {
            QName rstQn = new QName("requestSecurityToken");
            ServiceClient client = this.getServiceClient(rstQn, issuerAddress);
            client.getServiceContext().setProperty(RAMPART_POLICY, (Object)issuerPolicy);
            client.getOptions().setSoapVersionURI(this.soapVersion);
            if (this.addressingNs != null) {
                client.getOptions().setProperty("WSAddressingVersion", (Object)this.addressingNs);
            }
            client.engageModule("addressing");
            client.engageModule("rampart");
            this.processPolicy(issuerPolicy, null);
            OMElement response = client.sendReceive(rstQn, this.createRenewRequest(tokenType, tokenId));
            store.update(this.processRenewResponse(this.version, response, store, tokenId));
            return true;
        }
        catch (AxisFault e) {
            log.error((Object)"errorInRenewingToken", (Throwable)e);
            throw new TrustException("errorInRenewingToken", new String[]{issuerAddress}, e);
        }
    }

    private Token processRenewResponse(int version, OMElement elem, TokenStorage store, String id) throws TrustException {
        String ns;
        OMElement reqSecToken;
        OMElement rstr = elem;
        if (version == 2) {
            rstr = elem.getFirstElement();
        }
        if ((reqSecToken = rstr.getFirstChildWithName(new QName(ns = TrustUtil.getWSTNamespace(version), "RequestedSecurityToken"))) == null) {
            throw new TrustException("reqestedSecTokMissing");
        }
        OMElement lifeTimeEle = rstr.getFirstChildWithName(new QName(ns, "Lifetime"));
        if (lifeTimeEle == null) {
            throw new TrustException("lifeTimeElemMissing");
        }
        OMElement tokenElem = reqSecToken.getFirstElement();
        Token token = store.getToken(id);
        token.setPreviousToken(token.getToken());
        token.setToken(tokenElem);
        token.setState(4);
        token.setExpires(this.extractExpiryDate(lifeTimeEle));
        return token;
    }

    private Date extractExpiryDate(OMElement lifetimeElem) throws TrustException {
        try {
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            OMElement expiresElem = lifetimeElem.getFirstChildWithName(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires"));
            Date expires = zulu.parse(expiresElem.getText());
            return expires;
        }
        catch (OMException e) {
            throw new TrustException("lifeTimeProcessingError", new String[]{lifetimeElem.toString()}, e);
        }
        catch (ParseException e) {
            throw new TrustException("lifeTimeProcessingError", new String[]{lifetimeElem.toString()}, e);
        }
    }

    private ServiceClient getServiceClient(QName rstQn, String issuerAddress) throws AxisFault {
        AxisService axisService = new AxisService("SecurityTokenService" + UUIDGenerator.getUUID());
        axisService.setClientSide(true);
        OutInAxisOperation operation = new OutInAxisOperation(rstQn);
        axisService.addOperation((AxisOperation)operation);
        ServiceClient client = new ServiceClient(this.configCtx, axisService);
        if (this.options != null) {
            client.setOptions(this.options);
        }
        client.getOptions().setAction(this.action);
        client.getOptions().setTo(new EndpointReference(issuerAddress));
        client.engageModule("rampart");
        return client;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Token processIssueResponse(int version, OMElement result, String issuerAddress) throws TrustException {
        String ns;
        OMElement reqAttElem;
        OMElement rstr = result;
        if (version == 2 || version == 3) {
            rstr = result.getFirstElement();
        }
        OMElement reqAttRef = (reqAttElem = rstr.getFirstChildWithName(new QName(ns = TrustUtil.getWSTNamespace(version), "RequestedAttachedReference"))) == null ? null : reqAttElem.getFirstElement();
        OMElement reqUnattElem = rstr.getFirstChildWithName(new QName(ns, "RequestedUnattachedReference"));
        OMElement reqUnattRef = reqUnattElem == null ? null : reqUnattElem.getFirstElement();
        OMElement reqSecTok = rstr.getFirstChildWithName(new QName(ns, "RequestedSecurityToken"));
        if (reqSecTok == null) {
            throw new TrustException("reqestedSecTokMissing");
        }
        OMElement tokenElem = reqSecTok.getFirstElement();
        String id = this.findIdentifier(reqAttRef, reqUnattRef, tokenElem);
        if (id == null) {
            throw new TrustException("cannotObtainTokenIdentifier");
        }
        OMElement lifeTimeEle = rstr.getFirstChildWithName(new QName(ns, "Lifetime"));
        Token token = new Token(id, tokenElem, lifeTimeEle);
        token.setIssuerAddress(issuerAddress);
        token.setAttachedReference(reqAttRef);
        token.setUnattachedReference(reqUnattRef);
        OMElement rpt = rstr.getFirstChildWithName(new QName(ns, "RequestedProofToken"));
        byte[] secret = null;
        if (rpt != null) {
            OMElement child = rpt.getFirstElement();
            if (child == null) {
                throw new TrustException("invalidRPT");
            }
            if (child.getQName().equals(new QName(ns, "BinarySecret"))) {
                String b64Secret = child.getText();
                secret = Base64.decode((String)b64Secret);
            } else if (child.getQName().equals(new QName(ns, "EncryptedKey"))) {
                try {
                    Element domChild = (Element)new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), child.getXMLStreamReader()).getDocumentElement();
                    EncryptedKeyProcessor processor = new EncryptedKeyProcessor();
                    processor.handleToken(domChild, null, this.crypto, this.cbHandler, null, new Vector(), null);
                    secret = processor.getDecryptedBytes();
                }
                catch (WSSecurityException e) {
                    throw new TrustException("errorInProcessingEncryptedKey", e);
                }
            } else if (child.getQName().equals(new QName(ns, "ComputedKey"))) {
                OMElement serviceEntrElem = rstr.getFirstChildWithName(new QName(ns, "Entropy"));
                OMElement binSecElem = serviceEntrElem.getFirstElement();
                if (binSecElem == null || binSecElem.getText() == null || "".equals(binSecElem.getText().trim())) throw new TrustException("serviceEntropyMissing");
                byte[] serviceEntr = Base64.decode((String)binSecElem.getText());
                P_SHA1 p_sha1 = new P_SHA1();
                int length = this.keySize > 0 ? this.keySize : this.algorithmSuite.getMaximumSymmetricKeyLength();
                try {
                    secret = p_sha1.createKey(this.requestorEntropy, serviceEntr, 0, (long)(length / 8));
                }
                catch (ConversationException e) {
                    throw new TrustException("keyDerivationError", e);
                }
            }
        } else if (this.requestorEntropy != null) {
            secret = this.requestorEntropy;
        }
        token.setSecret(secret);
        return token;
    }

    private boolean processCancelResponse(OMElement response) {
        return response.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "RequestedTokenCancelled")) != null;
    }

    private String findIdentifier(OMElement reqAttRef, OMElement reqUnattRef, OMElement token) {
        String id;
        if (reqAttRef != null) {
            id = this.getIdFromSTR(reqAttRef);
        } else if (reqUnattRef != null) {
            id = this.getIdFromSTR(reqUnattRef);
        } else {
            log.debug((Object)"Attached and Unattached references are not present. Get Token ID from wsu:Id");
            id = token.getAttributeValue(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
            if (id == null) {
                log.debug((Object)"Get Token ID from attribute 'ID' in case we are dealing with SAML V2.0");
                id = token.getAttributeValue(new QName("ID"));
                if (id == null) {
                    log.debug((Object)"Get Token ID from attribute 'AssertionID' in case we are dealing with SAML V1.1");
                    id = token.getAttributeValue(new QName("AssertionID"));
                }
            }
        }
        return id;
    }

    private String getIdFromSTR(OMElement refElem) {
        OMElement child = refElem.getFirstElement();
        if (child == null) {
            return null;
        }
        if (child.getQName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo")) || child.getQName().equals(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier"))) {
            return child.getText();
        }
        if (child.getQName().equals(Reference.TOKEN)) {
            return child.getAttributeValue(new QName("URI"));
        }
        return null;
    }

    private void processPolicy(Policy issuerPolicy, Policy servicePolicy) {
        if (issuerPolicy != null) {
            log.debug((Object)"Processing Issuer policy");
            List issuerAssertions = (List)issuerPolicy.getAlternatives().next();
            for (Assertion tempAssertion : issuerAssertions) {
                if (!(tempAssertion instanceof Binding)) continue;
                log.debug((Object)"Extracting algo suite from issuer policy binding");
                this.algorithmSuite = ((Binding)tempAssertion).getAlgorithmSuite();
            }
        }
        if (servicePolicy != null) {
            log.debug((Object)"Processing service policy to find Trust10 assertion");
            List assertions = (List)servicePolicy.getAlternatives().next();
            for (Assertion tempAssertion : assertions) {
                if (tempAssertion instanceof Trust10) {
                    log.debug((Object)"Extracting Trust10 assertion from service policy");
                    this.trust10 = (Trust10)tempAssertion;
                    continue;
                }
                if (!(tempAssertion instanceof Trust13)) continue;
                log.debug((Object)"Extracting Trust13 assertion from service policy");
                this.trust13 = (Trust13)tempAssertion;
            }
        }
    }

    public OMElement createIssueRequest(String requestType, String appliesTo) throws TrustException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating request with request type: " + requestType + " and applies to: " + appliesTo));
        }
        OMElement rst = TrustUtil.createRequestSecurityTokenElement(this.version);
        TrustUtil.createRequestTypeElement(this.version, rst, requestType);
        if (appliesTo != null) {
            TrustUtil.createAppliesToElement(rst, appliesTo, this.addressingNs);
        }
        TrustUtil.createLifetimeElement(this.version, rst, this.ttl * 1000);
        if (this.rstTemplate != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using RSTTemplate: " + this.rstTemplate.toString()));
            }
            Iterator templateChildren = this.rstTemplate.cloneOMElement().getChildElements();
            while (templateChildren.hasNext()) {
                OMNode child = (OMNode)templateChildren.next();
                rst.addChild(child);
                if (!(child instanceof OMElement) || !((OMElement)child).getQName().equals(new QName(TrustUtil.getWSTNamespace(this.version), "KeySize"))) continue;
                log.debug((Object)"Extracting key size from the RSTTemplate: ");
                OMElement childElem = (OMElement)child;
                int n = this.keySize = childElem.getText() != null && !"".equals(childElem.getText()) ? Integer.parseInt(childElem.getText()) : -1;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Key size from RSTTemplate: " + this.keySize));
            }
        }
        try {
            OMElement binSec;
            OMElement ent;
            if (this.trust10 != null) {
                log.debug((Object)"Processing Trust assertion");
                if (this.trust10.isRequireClientEntropy()) {
                    log.debug((Object)"Requires client entropy");
                    ent = TrustUtil.createEntropyElement(this.version, rst);
                    binSec = TrustUtil.createBinarySecretElement(this.version, ent, "/Nonce");
                    this.requestorEntropy = WSSecurityUtil.generateNonce((int)(this.algorithmSuite.getMaximumSymmetricKeyLength() / 8));
                    binSec.setText(Base64.encode((byte[])this.requestorEntropy));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Clien entropy : " + Base64.encode((byte[])this.requestorEntropy)));
                    }
                    TrustUtil.createComputedKeyAlgorithm(this.version, rst, "/CK/PSHA1");
                }
            } else if (this.trust13 != null && this.trust13.isRequireClientEntropy()) {
                log.debug((Object)"Requires client entropy");
                ent = TrustUtil.createEntropyElement(this.version, rst);
                binSec = TrustUtil.createBinarySecretElement(this.version, ent, "/Nonce");
                this.requestorEntropy = WSSecurityUtil.generateNonce((int)(this.algorithmSuite.getMaximumSymmetricKeyLength() / 8));
                binSec.setText(Base64.encode((byte[])this.requestorEntropy));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Clien entropy : " + Base64.encode((byte[])this.requestorEntropy)));
                }
                TrustUtil.createComputedKeyAlgorithm(this.version, rst, "/CK/PSHA1");
            }
        }
        catch (Exception e) {
            throw new TrustException("errorSettingUpRequestorEntropy", e);
        }
        return rst;
    }

    private OMElement createValidateRequest(String requestType, String tokenId) throws TrustException {
        OMElement str;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating request with request type: " + requestType));
        }
        OMElement rst = TrustUtil.createRequestSecurityTokenElement(this.version);
        TrustUtil.createRequestTypeElement(this.version, rst, requestType);
        OMElement tokenTypeElem = TrustUtil.createTokenTypeElement(this.version, rst);
        String tokenType = TrustUtil.getWSTNamespace(this.version) + "/RSTR/Status";
        tokenTypeElem.setText(tokenType);
        TokenStorage store = TrustUtil.getTokenStore(this.configCtx);
        Token token = store.getToken(tokenId);
        if (token != null) {
            str = token.getUnattachedReference();
            if (str == null) {
                str = token.getAttachedReference();
            }
        } else {
            throw new TrustException("noToken", new String[]{tokenId});
        }
        TrustUtil.createValidateTargetElement(this.version, rst, str);
        return rst;
    }

    private OMElement createRenewRequest(String tokenType, String tokenId) throws TrustException {
        OMElement str;
        String requestType = TrustUtil.getWSTNamespace(this.version) + "/Renew";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating request with request type: " + requestType));
        }
        OMElement rst = TrustUtil.createRequestSecurityTokenElement(this.version);
        TrustUtil.createRequestTypeElement(this.version, rst, requestType);
        OMElement tokenTypeElem = TrustUtil.createTokenTypeElement(this.version, rst);
        tokenTypeElem.setText(tokenType);
        TokenStorage store = TrustUtil.getTokenStore(this.configCtx);
        Token token = store.getToken(tokenId);
        if (token != null) {
            str = token.getUnattachedReference();
            if (str == null) {
                str = token.getAttachedReference();
            }
        } else {
            throw new TrustException("noToken", new String[]{tokenId});
        }
        TrustUtil.createRenewTargetElement(this.version, rst, str);
        return rst;
    }

    private OMElement createCancelRequest(String tokenId) throws TrustException {
        return TrustUtil.createCancelRequest(tokenId, this.version);
    }

    public void setTrust10(Trust10 trust10) {
        this.trust10 = trust10;
    }

    public void setTrust13(Trust13 trust13) {
        this.trust13 = trust13;
    }

    public void setAlgorithmSuite(AlgorithmSuite algorithmSuite) {
        this.algorithmSuite = algorithmSuite;
    }

    public void setAddressingNs(String addressingNs) {
        this.addressingNs = addressingNs;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public void setCryptoInfo(Crypto crypto, CallbackHandler cbHandler) {
        this.crypto = crypto;
        this.cbHandler = cbHandler;
    }

    public void setCryptoInfo(Crypto crypto, String privKeyPasswd) {
        this.crypto = crypto;
        this.cbHandler = new CBHandler(privKeyPasswd);
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setRstTemplate(OMElement rstTemplate) {
        this.rstTemplate = rstTemplate;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public void addParameter(Parameter param) {
        this.parameters.add(param);
    }

    private static class CBHandler
    implements CallbackHandler {
        private String passwd;

        private CBHandler(String passwd) {
            this.passwd = passwd;
        }

        @Override
        public void handle(Callback[] cb) throws IOException, UnsupportedCallbackException {
            ((WSPasswordCallback)cb[0]).setPassword(this.passwd);
        }
    }
}

